/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.commands;

import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.CommandContext;
import com.zetaplugins.zetacore.commands.CommandExceptionHandler;
import com.zetaplugins.zetacore.commands.CommandUtils;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.GenericCommandException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PluginCommand<T extends JavaPlugin>
implements CommandExecutor,
TabCompleter {
    private final T plugin;
    private final Map<Class<? extends CommandException>, CommandExceptionHandler<? extends CommandException>> exceptionHandlers = new HashMap<Class<? extends CommandException>, CommandExceptionHandler<? extends CommandException>>();

    public PluginCommand(T plugin) {
        this.plugin = plugin;
        this.registerExceptionHandler(GenericCommandException.class, (ctx, e) -> e.getHandler().handle(ctx, (GenericCommandException)e));
    }

    protected T getPlugin() {
        return this.plugin;
    }

    public abstract boolean execute(CommandSender var1, Command var2, String var3, ArgumentList var4) throws CommandException;

    public abstract List<String> tabComplete(CommandSender var1, Command var2, ArgumentList var3);

    public boolean onCommand(@NotNull CommandSender commandSender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        ArgumentList argumentList = new ArgumentList(args);
        try {
            return this.execute(commandSender, command, label, argumentList);
        }
        catch (CommandException e) {
            return this.handleCommandException(commandSender, command, label, argumentList, e);
        }
    }

    @Nullable
    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        return this.tabComplete(sender, command, new ArgumentList(args));
    }

    public final <E extends CommandException> void registerExceptionHandler(Class<E> exceptionClass, CommandExceptionHandler<E> handler) {
        this.exceptionHandlers.put(exceptionClass, handler);
    }

    private boolean handleCommandException(CommandSender sender, Command command, String label, ArgumentList args, CommandException e) {
        for (Class<?> clazz = e.getClass(); clazz != null && CommandException.class.isAssignableFrom(clazz); clazz = clazz.getSuperclass()) {
            CommandExceptionHandler<CommandException> handler = this.getHandler(clazz);
            if (handler == null) continue;
            return handler.handle(new CommandContext(sender, command, label, args), e);
        }
        return false;
    }

    private <E extends CommandException> CommandExceptionHandler<E> getHandler(Class<?> clazz) {
        return this.exceptionHandlers.get(clazz);
    }

    protected final List<String> getDisplayOptions(List<String> options, String input) {
        return CommandUtils.getDisplayOptions(options, input);
    }

    protected final List<String> getPlayerOptions(String input) {
        return CommandUtils.getPlayerOptions(this.getPlugin(), input);
    }
}

