/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.papi;

import com.zetaplugins.zetacore.annotations.Papi;
import com.zetaplugins.zetacore.services.papi.PlaceholderFunction;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import me.clip.placeholderapi.expansion.PlaceholderExpansion;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PapiExpansionService {
    private String identifier;
    private String author;
    private String version;
    private Map<String, PlaceholderFunction> placeholders;
    private Logger logger;
    private String playerNotFoundMessage = "PlayerNotFound";
    private String playerNotOnlineMessage = "PlayerNotOnline";

    public PapiExpansionService() {
        this.placeholders = new HashMap<String, PlaceholderFunction>();
    }

    public PapiExpansionService(String identifier, String author, String version, Logger logger) {
        this.identifier = identifier;
        this.author = author;
        this.version = version;
        this.placeholders = new HashMap<String, PlaceholderFunction>();
        this.logger = logger;
    }

    public PapiExpansionService(JavaPlugin plugin) {
        this.identifier = plugin.getName().toLowerCase();
        this.author = plugin.getDescription().getAuthors().isEmpty() ? "Unknown" : (String)plugin.getDescription().getAuthors().get(0);
        this.version = plugin.getDescription().getVersion();
        this.placeholders = new HashMap<String, PlaceholderFunction>();
        this.logger = plugin.getLogger();
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public PapiExpansionService setIdentifier(String identifier) {
        this.identifier = identifier;
        return this;
    }

    public String getAuthor() {
        return this.author;
    }

    public PapiExpansionService setAuthor(String author) {
        this.author = author;
        return this;
    }

    public String getVersion() {
        return this.version;
    }

    public PapiExpansionService setVersion(String version) {
        this.version = version;
        return this;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public PapiExpansionService setLogger(Logger logger) {
        this.logger = logger;
        return this;
    }

    public String getPlayerNotFoundMessage() {
        return this.playerNotFoundMessage;
    }

    public PapiExpansionService setPlayerNotFoundMessage(@Nullable String playerNotFoundMessage) {
        this.playerNotFoundMessage = playerNotFoundMessage;
        return this;
    }

    public String getPlayerNotOnlineMessage() {
        return this.playerNotOnlineMessage;
    }

    public PapiExpansionService setPlayerNotOnlineMessage(@Nullable String playerNotOnlineMessage) {
        this.playerNotOnlineMessage = playerNotOnlineMessage;
        return this;
    }

    public Map<String, PlaceholderFunction> getPlaceholders() {
        return this.placeholders;
    }

    public PapiExpansionService setPlaceholders(Map<String, PlaceholderFunction> placeholders) {
        this.placeholders = placeholders;
        return this;
    }

    public PapiExpansionService addPlaceholder(String key, PlaceholderFunction function) {
        this.placeholders.put(key, function);
        return this;
    }

    public PapiExpansionService addAnnotatedPlaceholders(Object obj) {
        Class<?> clazz = obj.getClass();
        for (Method method : clazz.getDeclaredMethods()) {
            if (!method.isAnnotationPresent(Papi.class)) continue;
            Papi annotation = method.getAnnotation(Papi.class);
            String key = annotation.identifier();
            method.setAccessible(true);
            this.addPlaceholder(key, (player, identifier) -> {
                try {
                    if (method.getParameterCount() == 0) {
                        return (String)method.invoke(obj, new Object[0]);
                    }
                    if (method.getParameterCount() == 1) {
                        Class<?> paramType = method.getParameterTypes()[0];
                        if (paramType == OfflinePlayer.class) {
                            return (String)method.invoke(obj, player);
                        }
                        if (paramType == Player.class) {
                            if (!player.isOnline()) {
                                return this.playerNotOnlineMessage;
                            }
                            return (String)method.invoke(obj, player.getPlayer());
                        }
                        throw new IllegalArgumentException("Unsupported parameter type for Papi method: " + paramType.getName());
                    }
                    throw new IllegalArgumentException("Papi method must have 0 or 1 parameters.");
                }
                catch (Exception e) {
                    if (this.logger != null) {
                        this.logger.log(Level.SEVERE, "Error executing PAPI placeholder method for identifier '" + key + "': " + e.getMessage(), e);
                    } else {
                        e.printStackTrace();
                    }
                    return "ErrorExecutingPlaceholder";
                }
            });
        }
        return this;
    }

    public static boolean hasPapi() {
        return Bukkit.getPluginManager().getPlugin("PlaceholderAPI") != null;
    }

    public boolean register() throws IllegalStateException {
        if (this.identifier == null || this.author == null || this.version == null || this.placeholders == null) {
            throw new IllegalStateException("Identifier, author, version, and placeholders must be set before registering the expansion.");
        }
        if (!PapiExpansionService.hasPapi()) {
            return false;
        }
        PlaceholderExpansion expansion = new PlaceholderExpansion(){

            @NotNull
            public String getIdentifier() {
                return PapiExpansionService.this.identifier;
            }

            @NotNull
            public String getAuthor() {
                return PapiExpansionService.this.author;
            }

            @NotNull
            public String getVersion() {
                return PapiExpansionService.this.version;
            }

            public String onRequest(OfflinePlayer player, @NotNull String identifier) {
                if (player == null) {
                    return PapiExpansionService.this.playerNotFoundMessage;
                }
                PlaceholderFunction function = PapiExpansionService.this.placeholders.get(identifier);
                if (function != null) {
                    return function.apply(player, identifier);
                }
                return null;
            }
        };
        if (!expansion.canRegister()) {
            return false;
        }
        expansion.register();
        return true;
    }
}

