/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.di;

import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.annotations.InjectPlugin;
import com.zetaplugins.zetacore.annotations.Manager;
import com.zetaplugins.zetacore.annotations.PostManagerConstruct;
import com.zetaplugins.zetacore.libs.reflections.Reflections;
import com.zetaplugins.zetacore.libs.reflections.scanners.Scanner;
import com.zetaplugins.zetacore.services.di.ManagerScope;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.bukkit.plugin.java.JavaPlugin;

public class ManagerRegistry {
    private final JavaPlugin plugin;
    private final Map<Class<?>, Object> instances = new HashMap();
    private final boolean requireManagerAnnotation;
    private final String packagePrefix;
    private final ThreadLocal<Deque<Class<?>>> creationStack = ThreadLocal.withInitial(ArrayDeque::new);

    public ManagerRegistry(JavaPlugin plugin) {
        this.plugin = plugin;
        this.instances.put(plugin.getClass(), plugin);
        this.instances.put(JavaPlugin.class, plugin);
        this.requireManagerAnnotation = false;
        this.packagePrefix = plugin.getClass().getPackageName();
    }

    public ManagerRegistry(JavaPlugin plugin, boolean requireManagerAnnotation, String packagePrefix) {
        this.plugin = plugin;
        this.instances.put(plugin.getClass(), plugin);
        this.instances.put(JavaPlugin.class, plugin);
        this.requireManagerAnnotation = requireManagerAnnotation;
        this.packagePrefix = packagePrefix;
    }

    public void initializeEagerManagers() {
        Reflections reflections = new Reflections(this.packagePrefix, new Scanner[0]);
        Set<Class<?>> annotatedClasses = reflections.getTypesAnnotatedWith(Manager.class);
        for (Class<?> cls : annotatedClasses) {
            ManagerOptions options = this.getManagerOptions(cls);
            if (!options.eagerlyLoad() || options.scope() != ManagerScope.SINGLETON) continue;
            this.getOrCreate(cls);
        }
    }

    public void registerInstance(Object instance) {
        this.requireManagerAnnotation(instance.getClass());
        this.injectManagers(instance);
        this.instances.put(instance.getClass(), instance);
    }

    public void registerInstance(Class<?> cls, Object instance) {
        this.requireManagerAnnotation(cls);
        this.injectManagers(instance);
        this.instances.put(cls, instance);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public <T> T getOrCreate(Class<T> cls) {
        this.requireManagerAnnotation(cls);
        Deque<Class<?>> stack = this.creationStack.get();
        if (stack.contains(cls)) {
            throw new RuntimeException("Circular dependency detected: " + String.valueOf(stack) + " -> " + cls.getName());
        }
        stack.push(cls);
        try {
            ManagerOptions options;
            if (cls.isAnnotationPresent(Manager.class) && (options = this.getManagerOptions(cls)).scope() == ManagerScope.PROTOTYPE) {
                try {
                    T obj = this.createInstance(cls);
                    this.injectManagers(obj);
                    T t = obj;
                    return t;
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create prototype instance of " + cls.getName(), e);
                }
            }
            Object existing = this.instances.get(cls);
            if (existing != null) {
                Object e = existing;
                return (T)e;
            }
            T obj = this.createInstance(cls);
            this.instances.put(cls, obj);
            this.injectManagers(obj);
            T t = obj;
            return t;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of " + cls.getName(), e);
        }
        finally {
            stack.pop();
        }
    }

    private <T> T createInstance(Class<T> cls) {
        try {
            for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
                Class<?>[] params = constructor.getParameterTypes();
                if (params.length != 1 || !params[0].isAssignableFrom(this.plugin.getClass()) && !params[0].isAssignableFrom(JavaPlugin.class)) continue;
                constructor.setAccessible(true);
                Object obj = constructor.newInstance(this.plugin);
                return cls.cast(obj);
            }
            Constructor<T> noArg = cls.getDeclaredConstructor(new Class[0]);
            noArg.setAccessible(true);
            T obj = noArg.newInstance(new Object[0]);
            this.injectManagers(obj);
            return obj;
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw new RuntimeException("Failed to create instance of " + cls.getName() + ". The class must have either a no-argument constructor or a constructor that accepts the plugin instance.", e);
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Failed to cast instance of " + cls.getName(), e);
        }
        catch (Exception e) {
            throw new RuntimeException("Unexpected error while creating instance of " + cls.getName(), e);
        }
    }

    public void injectManagers(Object target) {
        for (Class<?> cls = target.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
            for (Field field : cls.getDeclaredFields()) {
                this.injectManagerIntoField(field, target);
                this.injectPluginIntoField(field, target);
            }
        }
        this.callPostConstructMethods(target);
    }

    private void injectManagerIntoField(Field field, Object target) {
        if (!field.isAnnotationPresent(InjectManager.class)) {
            return;
        }
        Object instance = this.getOrCreate(field.getType());
        try {
            field.setAccessible(true);
            field.set(target, instance);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
    }

    private void injectPluginIntoField(Field field, Object target) {
        if (field.isAnnotationPresent(InjectPlugin.class)) {
            if (!JavaPlugin.class.isAssignableFrom(field.getType())) {
                throw new RuntimeException("Field " + field.getName() + " is annotated with @InjectPlugin but is not of type JavaPlugin or a subclass.");
            }
            try {
                field.setAccessible(true);
                field.set(target, this.plugin);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void callPostConstructMethods(Object target) {
        for (Class<?> cls = target.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PostManagerConstruct.class)) continue;
                if (method.getParameterCount() != 0) {
                    throw new RuntimeException("@PostManagerConstruct method " + method.getName() + " must have no parameters");
                }
                try {
                    method.setAccessible(true);
                    method.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to execute @PostManagerConstruct method " + method.getName(), e);
                }
            }
        }
    }

    private void requireManagerAnnotation(Class<?> cls) {
        if (this.requireManagerAnnotation && !cls.isAnnotationPresent(Manager.class)) {
            throw new RuntimeException("Class " + cls.getName() + " is not annotated with @Manager");
        }
    }

    private ManagerOptions getManagerOptions(Class<?> cls) {
        if (cls.isAnnotationPresent(Manager.class)) {
            Manager managerAnnotation = cls.getAnnotation(Manager.class);
            return new ManagerOptions(managerAnnotation.eagerlyLoad(), managerAnnotation.scope());
        }
        return new ManagerOptions(false, ManagerScope.SINGLETON);
    }

    record ManagerOptions(boolean eagerlyLoad, ManagerScope scope) {
    }
}

