/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.config;

import com.zetaplugins.zetacore.services.config.PluginConfig;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public class ConfigService {
    private final JavaPlugin plugin;
    private final Map<String, FileConfiguration> configCache;

    public ConfigService(JavaPlugin plugin) {
        this.plugin = plugin;
        this.configCache = new HashMap<String, FileConfiguration>();
    }

    public FileConfiguration getConfig(PluginConfig config) {
        return this.getFileConfigFromFileName(config.getFileName(), true);
    }

    public FileConfiguration getConfig(PluginConfig config, boolean useCache) {
        return this.getFileConfigFromFileName(config.getFileName(), useCache);
    }

    public FileConfiguration getConfig(String fileName) {
        return this.getFileConfigFromFileName(fileName, true);
    }

    public FileConfiguration getConfig(String fileName, boolean useCache) {
        return this.getFileConfigFromFileName(fileName, useCache);
    }

    private FileConfiguration getFileConfigFromFileName(String fileName, boolean useCache) {
        if (useCache && this.configCache.containsKey(fileName)) {
            return this.configCache.get(fileName);
        }
        File configFile = new File(this.plugin.getDataFolder(), fileName + ".yml");
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            this.plugin.saveResource(fileName + ".yml", false);
        }
        YamlConfiguration fileConfig = YamlConfiguration.loadConfiguration((File)configFile);
        if (useCache) {
            this.configCache.put(fileName, (FileConfiguration)fileConfig);
        }
        return fileConfig;
    }

    public void saveConfig(PluginConfig config, FileConfiguration fileConfig) {
        this.saveFileConfigToFileName(config.getFileName(), fileConfig);
    }

    public void saveConfig(String fileName, FileConfiguration fileConfig) {
        this.saveFileConfigToFileName(fileName, fileConfig);
    }

    private void saveFileConfigToFileName(String fileName, FileConfiguration fileConfig) {
        File configFile = new File(this.plugin.getDataFolder(), fileName + ".yml");
        try {
            fileConfig.save(configFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save configuration file: " + fileName + ".yml", e);
        }
    }

    public void clearCache() {
        this.configCache.clear();
    }
}

