/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.commands;

import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public record RegisterableCommand(String name, List<String> aliases, String description, String usage, String permission) {
    private static final String UNSET = "__UNSET__";

    @NotNull
    private Command getCommand(final CommandExecutor executor, final TabCompleter tabCompleter) {
        return new BukkitCommand(this.name){

            public boolean execute(@NotNull CommandSender commandSender, @NotNull String commandLabel, @NotNull @NotNull String @NotNull [] args) {
                return executor.onCommand(commandSender, (Command)this, commandLabel, args);
            }

            @NotNull
            public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) throws IllegalArgumentException {
                List completions = tabCompleter.onTabComplete(sender, (Command)this, alias, args);
                return completions == null ? List.of() : completions;
            }
        };
    }

    private void setPluginCommandAttributes(Command command) {
        String commandName = command.getName();
        if (!this.aliases.isEmpty()) {
            command.setAliases(this.aliases);
        }
        if (this.description != null && !this.description.equals(UNSET)) {
            command.setDescription(this.description.replaceAll("%command%", commandName));
        }
        if (this.usage != null && !this.usage.equals(UNSET)) {
            command.setUsage(this.usage.replaceAll("%command%", commandName));
        }
        if (this.permission != null && !this.permission.equals(UNSET)) {
            command.setPermission(this.permission.replaceAll("%command%", commandName));
        }
    }

    public boolean register(JavaPlugin plugin, String commandNamespace, CommandMap commandMap, CommandExecutor executor, TabCompleter tabCompleter) {
        PluginCommand command = plugin.getCommand(this.name);
        if (command != null) {
            command.setExecutor(executor);
            if (tabCompleter != null) {
                command.setTabCompleter(tabCompleter);
            }
            this.setPluginCommandAttributes((Command)command);
            return true;
        }
        if (commandMap == null) {
            plugin.getLogger().severe("CommandMap is null, cannot register command: " + this.name);
            return false;
        }
        try {
            Command newCommand = this.getCommand(executor, tabCompleter);
            this.setPluginCommandAttributes(newCommand);
            boolean sucess = commandMap.register(this.name, commandNamespace, newCommand);
            if (!sucess) {
                plugin.getLogger().severe("Failed to manually register command: " + this.name);
                return false;
            }
            return true;
        }
        catch (Exception e) {
            plugin.getLogger().severe("Exception while registering command: " + this.name);
            return false;
        }
    }

    public static RegisterableCommand fromAnnotation(String name, AutoRegisterCommand annotation) {
        String permission;
        String usage;
        String description;
        String[] aliases;
        try {
            Method aliasesMethod = annotation.annotationType().getMethod("aliases", new Class[0]);
            aliases = (String[])aliasesMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            aliases = new String[]{};
        }
        try {
            Method descriptionMethod = annotation.annotationType().getMethod("description", new Class[0]);
            description = (String)descriptionMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            description = null;
        }
        try {
            Method usageMethod = annotation.annotationType().getMethod("usage", new Class[0]);
            usage = (String)usageMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            usage = null;
        }
        try {
            Method permissionMethod = annotation.annotationType().getMethod("permission", new Class[0]);
            permission = (String)permissionMethod.invoke((Object)annotation, new Object[0]);
        }
        catch (Exception e) {
            permission = null;
        }
        return new RegisterableCommand(name, Arrays.asList(aliases), description, usage, permission);
    }
}

