/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.updatechecker;

import com.zetaplugins.zetacore.services.updatechecker.SemanticVersion;
import com.zetaplugins.zetacore.services.updatechecker.UpdateChecker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class ModrinthUpdateChecker
extends UpdateChecker {
    private final String projectId;

    public ModrinthUpdateChecker(JavaPlugin plugin, String projectId) {
        super(plugin);
        this.projectId = projectId;
    }

    @Override
    public void checkForUpdates(boolean logMessage) {
        String latestVersion = this.fetchLatestVersion();
        if (latestVersion == null) {
            return;
        }
        String currentVersion = this.getPlugin().getDescription().getVersion();
        if (this.modrinthVersionIsNewer(latestVersion, currentVersion)) {
            this.setNewVersionAvailable(true);
            this.setLatestVersion(latestVersion);
            this.getLogger().info(this.getNewVersionConsoleMessage(latestVersion, currentVersion, this.getLatestVersionUrl(latestVersion)));
        } else {
            this.setNewVersionAvailable(false);
        }
    }

    private String getModrinthProjectUrl() {
        return "https://api.modrinth.com/v2/project/" + this.projectId;
    }

    private String getLatestVersionUrl(String version) {
        return "https://modrinth.com/plugin/" + this.projectId + "/version/" + version;
    }

    private boolean modrinthVersionIsNewer(String latestVersion, String currentVersion) {
        try {
            SemanticVersion latest = new SemanticVersion(latestVersion);
            SemanticVersion current = new SemanticVersion(currentVersion);
            return latest.isGreaterThan(current);
        }
        catch (IllegalArgumentException e) {
            return !latestVersion.trim().equals(currentVersion.trim());
        }
    }

    private String fetchLatestVersion() {
        String mcVersion = this.getPlugin().getServer().getMinecraftVersion();
        String encodedGameVersion = URLEncoder.encode("[\"" + mcVersion + "\"]", StandardCharsets.UTF_8);
        String versionsUrl = this.getModrinthProjectUrl() + "/version?game_versions=" + encodedGameVersion;
        JSONArray versionsArray = this.fetchJsonArrayFromUrl(versionsUrl);
        if (versionsArray == null || versionsArray.isEmpty()) {
            return null;
        }
        JSONObject latestVersion = (JSONObject)versionsArray.get(0);
        return (String)latestVersion.get((Object)"version_number");
    }

    private JSONArray fetchJsonArrayFromUrl(String urlString) {
        try {
            HttpURLConnection connection = this.createHttpConnection(urlString);
            if (connection.getResponseCode() == 200) {
                String response = this.readResponse(connection);
                return (JSONArray)new JSONParser().parse(response);
            }
            this.getLogger().warning("Failed to retrieve data from " + urlString + " Response code: " + connection.getResponseCode());
        }
        catch (IOException | ParseException e) {
            this.getLogger().warning("Error fetching data: " + e.getMessage());
        }
        return null;
    }

    private JSONObject fetchJsonFromUrl(String urlString) {
        try {
            HttpURLConnection connection = this.createHttpConnection(urlString);
            if (connection.getResponseCode() == 200) {
                String response = this.readResponse(connection);
                return (JSONObject)new JSONParser().parse(response);
            }
            this.getLogger().warning("Failed to retrieve data from " + urlString + " Response code: " + connection.getResponseCode());
        }
        catch (IOException | ParseException e) {
            this.getLogger().warning("Error fetching data: " + e.getMessage());
        }
        return null;
    }

    private HttpURLConnection createHttpConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        return connection;
    }

    private String readResponse(HttpURLConnection connection) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
    }
}

