/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.messages;

import com.zetaplugins.zetacore.services.localization.LocalizationService;
import com.zetaplugins.zetacore.services.messages.BaseMessageService;
import com.zetaplugins.zetacore.services.messages.Messenger;
import com.zetaplugins.zetacore.services.messages.Replaceable;
import java.util.List;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.serializer.legacy.LegacyComponentSerializer;
import org.bukkit.command.CommandSender;

public class LegacyMessenger
extends BaseMessageService
implements Messenger {
    private final MiniMessage mm = MiniMessage.miniMessage();
    private final LegacyComponentSerializer legacySerializer = LegacyComponentSerializer.legacySection();

    public LegacyMessenger(LocalizationService localizationService) {
        super(localizationService);
    }

    @Override
    public void send(CommandSender player, boolean addPrefix, String path, String fallback, Replaceable<?> ... replaceables) {
        String raw = this.getRawMessage(path, fallback, addPrefix);
        String processed = this.replacePlaceholdersWithAccentColors("<!i>" + raw, replaceables);
        String legacy = this.legacySerializer.serialize(this.mm.deserialize((Object)processed));
        player.sendMessage(legacy);
    }

    @Override
    public void sendRaw(CommandSender player, String rawMessage, Replaceable<?> ... replaceables) {
        String processed = this.replacePlaceholdersWithAccentColors("<!i>" + rawMessage, new Replaceable[0]);
        String legacy = this.legacySerializer.serialize(this.mm.deserialize((Object)processed));
        player.sendMessage(legacy);
    }

    @Override
    public void sendList(CommandSender player, String path, Replaceable<?> ... replaceables) {
        List<String> rawList = this.getRawMessageList(path);
        for (String item : rawList) {
            String processed = this.replacePlaceholdersWithAccentColors("<!i>" + item, replaceables);
            player.sendMessage(this.legacySerializer.serialize(this.mm.deserialize((Object)processed)));
        }
    }
}

