/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.commands;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;
import org.jetbrains.annotations.NotNull;

public class ArgumentList
implements Iterable<String> {
    private final String[] args;

    public ArgumentList(String[] args) {
        this.args = args;
    }

    public boolean hasArg(int index) {
        return this.args.length > index;
    }

    public String getArg(int index) {
        if (this.hasArg(index)) {
            return this.args[index];
        }
        return null;
    }

    public String getString(int index, String defaultValue) {
        if (this.hasArg(index)) {
            return this.args[index];
        }
        return defaultValue;
    }

    public String getJoinedString(int startIndex) {
        return this.getJoinedString(startIndex, " ");
    }

    public String getJoinedString(int startIndex, String seperator) {
        if (!this.hasArg(startIndex)) {
            return "";
        }
        StringBuilder joined = new StringBuilder();
        for (int i = startIndex; i < this.args.length; ++i) {
            joined.append(this.args[i]);
            if (i >= this.args.length - 1) continue;
            joined.append(seperator);
        }
        return joined.toString();
    }

    public Player getPlayer(int index, JavaPlugin plugin) {
        if (!this.hasArg(index)) {
            return null;
        }
        return plugin.getServer().getPlayer(this.args[index]);
    }

    public Player getPlayer(int index, Player defaultPlayer, JavaPlugin plugin) {
        if (!this.hasArg(index)) {
            return defaultPlayer;
        }
        return plugin.getServer().getPlayer(this.args[index]);
    }

    public int getInt(int index) throws NumberFormatException {
        if (!this.hasArg(index)) {
            throw new NumberFormatException();
        }
        return Integer.parseInt(this.args[index]);
    }

    public double getDouble(int index) throws NumberFormatException {
        if (!this.hasArg(index)) {
            throw new NumberFormatException();
        }
        return Double.parseDouble(this.args[index]);
    }

    public long getLong(int index) throws NumberFormatException {
        if (!this.hasArg(index)) {
            throw new NumberFormatException();
        }
        return Long.parseLong(this.args[index]);
    }

    public int getInt(int index, int defaultValue) {
        if (!this.hasArg(index)) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(this.args[index]);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public int getInt(int index, int defaultValue, int min, int max) {
        int val = this.getInt(index, defaultValue);
        return Math.max(min, Math.min(max, val));
    }

    public double getDouble(int index, double defaultValue) {
        if (!this.hasArg(index)) {
            return defaultValue;
        }
        try {
            return Double.parseDouble(this.args[index]);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public long getLong(int index, long defaultValue) {
        if (!this.hasArg(index)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(this.args[index]);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public boolean getBoolean(int index, boolean defaultValue) {
        String val;
        if (!this.hasArg(index)) {
            return defaultValue;
        }
        return switch (val = this.args[index].toLowerCase()) {
            case "true", "yes", "y", "1" -> true;
            case "false", "no", "n", "0" -> false;
            default -> defaultValue;
        };
    }

    public <E extends Enum<E>> E getEnum(int index, Class<E> enumClass) {
        if (!this.hasArg(index)) {
            return null;
        }
        try {
            return Enum.valueOf(enumClass, this.args[index].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    public <E extends Enum<E>> E getEnum(int index, Class<E> enumClass, E defaultValue) {
        if (!this.hasArg(index)) {
            return defaultValue;
        }
        try {
            return Enum.valueOf(enumClass, this.args[index].toUpperCase());
        }
        catch (IllegalArgumentException e) {
            return defaultValue;
        }
    }

    public <E extends Enum<E>> E getEnumIgnoreCase(int index, Class<E> enumClass, E defaultValue) {
        if (!this.hasArg(index)) {
            return defaultValue;
        }
        String input = this.args[index];
        for (Enum constant : (Enum[])enumClass.getEnumConstants()) {
            if (!constant.name().equalsIgnoreCase(input)) continue;
            return (E)constant;
        }
        return defaultValue;
    }

    public int getCurrentArgIndex() {
        return this.args.length - 1;
    }

    public String getCurrentArg() {
        if (this.args.length == 0) {
            return null;
        }
        return this.args[this.getCurrentArgIndex()];
    }

    public int size() {
        return this.args.length;
    }

    public String[] getArgs() {
        return this.args;
    }

    public List<String> getAllArgs() {
        return new ArrayList<String>(List.of(this.args));
    }

    @Override
    @NotNull
    public Iterator<String> iterator() {
        return Arrays.asList(this.args).iterator();
    }

    public String toString() {
        return "ArgumentList{args=" + Arrays.toString(this.args) + "}";
    }
}

