/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.commands;

import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterTabCompleter;
import com.zetaplugins.zetacore.libs.reflections.Reflections;
import com.zetaplugins.zetacore.libs.reflections.scanners.Scanner;
import com.zetaplugins.zetacore.services.commands.CommandRegistrar;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.plugin.java.JavaPlugin;

public class AutoCommandRegistrar
implements CommandRegistrar {
    private final JavaPlugin plugin;
    private final String packagePrefix;

    public AutoCommandRegistrar(JavaPlugin plugin, String packagePrefix) {
        this.plugin = plugin;
        this.packagePrefix = packagePrefix;
    }

    @Override
    public List<String> registerAllCommands() {
        Reflections reflections = new Reflections(this.packagePrefix, new Scanner[0]);
        ArrayList<String> registeredCommands = new ArrayList<String>();
        HashMap<String, TabCompleter> tabCompleters = new HashMap<String, TabCompleter>();
        Set<Class<?>> tabCompleterClasses = reflections.getTypesAnnotatedWith(AutoRegisterTabCompleter.class);
        for (Class<?> clazz : tabCompleterClasses) {
            ArrayList<String> names;
            TabCompleter completer;
            block12: {
                if (!TabCompleter.class.isAssignableFrom(clazz)) continue;
                AutoRegisterTabCompleter annotation = clazz.getAnnotation(AutoRegisterTabCompleter.class);
                completer = this.createTabCompleter(clazz);
                if (completer == null) continue;
                names = new ArrayList<String>();
                try {
                    Method commandsMethod = annotation.annotationType().getMethod("commands", new Class[0]);
                    String[] arr = (String[])commandsMethod.invoke((Object)annotation, new Object[0]);
                    if (arr != null && arr.length > 0) {
                        for (String n : arr) {
                            if (n == null || n.isEmpty()) continue;
                            names.add(n);
                        }
                        break block12;
                    }
                    throw new NoSuchMethodException();
                }
                catch (NoSuchMethodException ignored) {
                    try {
                        Method commandMethod = annotation.annotationType().getMethod("command", new Class[0]);
                        String n = (String)commandMethod.invoke((Object)annotation, new Object[0]);
                        if (n != null && !n.isEmpty()) {
                            names.add(n);
                        }
                    }
                    catch (NoSuchMethodException ignored2) {
                        this.plugin.getLogger().warning("AutoRegisterTabCompleter annotation on " + clazz.getSimpleName() + " has no 'commands' or 'command' method");
                    }
                    catch (Exception e) {
                        this.plugin.getLogger().log(Level.WARNING, "Failed to read AutoRegisterTabCompleter annotation on " + clazz.getSimpleName(), e);
                    }
                }
                catch (Exception e) {
                    this.plugin.getLogger().log(Level.WARNING, "Failed to read AutoRegisterTabCompleter annotation on " + clazz.getSimpleName(), e);
                }
            }
            for (String name : names) {
                tabCompleters.put(name, completer);
            }
        }
        Set<Class<?>> commandClasses = reflections.getTypesAnnotatedWith(AutoRegisterCommand.class);
        for (Class<?> clazz : commandClasses) {
            List<String> names;
            if (!CommandExecutor.class.isAssignableFrom(clazz) || (names = this.registerCommand(clazz, tabCompleters)) == null || names.isEmpty()) continue;
            registeredCommands.addAll(names);
        }
        registeredCommands.sort(String::compareTo);
        return registeredCommands;
    }

    private TabCompleter createTabCompleter(Class<?> completerClass) {
        try {
            try {
                Constructor<?> constructor = completerClass.getConstructor(this.plugin.getClass());
                return (TabCompleter)constructor.newInstance(this.plugin);
            }
            catch (NoSuchMethodException e) {
                Constructor<?> constructor = completerClass.getConstructor(new Class[0]);
                return (TabCompleter)constructor.newInstance(new Object[0]);
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.WARNING, "Failed to create tab completer: " + completerClass.getSimpleName(), e);
            return null;
        }
    }

    private List<String> registerCommand(Class<?> commandClass, Map<String, TabCompleter> tabCompleters) {
        ArrayList<String> result = new ArrayList<String>();
        try {
            CommandExecutor executor;
            ArrayList<String> commandNames;
            AutoRegisterCommand annotation;
            block20: {
                annotation = commandClass.getAnnotation(AutoRegisterCommand.class);
                if (annotation == null) {
                    return result;
                }
                commandNames = new ArrayList<String>();
                try {
                    Method commandsMethod = annotation.annotationType().getMethod("commands", new Class[0]);
                    String[] names = (String[])commandsMethod.invoke((Object)annotation, new Object[0]);
                    if (names != null && names.length > 0) {
                        for (String n : names) {
                            if (n == null || n.isEmpty()) continue;
                            commandNames.add(n);
                        }
                        break block20;
                    }
                    throw new NoSuchMethodException();
                }
                catch (NoSuchMethodException ignored) {
                    try {
                        Method commandMethod = annotation.annotationType().getMethod("command", new Class[0]);
                        String name = (String)commandMethod.invoke((Object)annotation, new Object[0]);
                        if (name != null && !name.isEmpty()) {
                            commandNames.add(name);
                        }
                    }
                    catch (NoSuchMethodException ignored2) {
                        this.plugin.getLogger().warning("AutoRegisterCommand annotation on " + commandClass.getSimpleName() + " has no 'commands' or 'command' method");
                    }
                }
            }
            if (commandNames.isEmpty()) {
                return result;
            }
            try {
                Constructor<?> constructor = commandClass.getConstructor(this.plugin.getClass());
                executor = (CommandExecutor)constructor.newInstance(this.plugin);
            }
            catch (NoSuchMethodException e) {
                try {
                    Constructor<?> constructor = commandClass.getConstructor(new Class[0]);
                    executor = (CommandExecutor)constructor.newInstance(new Object[0]);
                }
                catch (NoSuchMethodException ex) {
                    this.plugin.getLogger().severe("No suitable constructor found for command class: " + commandClass.getSimpleName());
                    return null;
                }
            }
            String displayName = annotation.name().isEmpty() ? commandClass.getSimpleName() : annotation.name();
            for (String commandName : commandNames) {
                PluginCommand command = this.plugin.getCommand(commandName);
                if (command != null) {
                    command.setExecutor(executor);
                    if (executor instanceof TabCompleter) {
                        command.setTabCompleter((TabCompleter)executor);
                    } else if (tabCompleters.containsKey(commandName)) {
                        command.setTabCompleter(tabCompleters.get(commandName));
                    }
                    result.add(displayName);
                    continue;
                }
                this.plugin.getLogger().warning("Command '" + commandName + "' not found in plugin.yml");
            }
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to register command: " + commandClass.getSimpleName(), e);
        }
        return result;
    }

    @Override
    public void registerCommand(String name, CommandExecutor executor, TabCompleter tabCompleter) {
        PluginCommand command = this.plugin.getCommand(name);
        if (command != null) {
            command.setExecutor(executor);
            if (tabCompleter != null) {
                command.setTabCompleter(tabCompleter);
            }
        }
    }
}

