/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.debug.uploader;

import com.zetaplugins.zetacore.debug.data.DebugReport;
import com.zetaplugins.zetacore.debug.uploader.ReportUploader;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.logging.Level;
import org.bukkit.plugin.java.JavaPlugin;

public final class MclogsReportUploader
extends ReportUploader {
    public MclogsReportUploader(JavaPlugin plugin) {
        super(plugin);
    }

    public static String uploadReport(DebugReport debugReport, JavaPlugin plugin) {
        return new MclogsReportUploader(plugin).uploadReport(debugReport);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public String uploadReport(DebugReport debugReport) {
        try {
            HttpURLConnection connection = this.getHttpURLConnection(new URL("https://api.mclo.gs/1/log"));
            connection.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
            String encodedContent = "content=" + URLEncoder.encode(debugReport.toReadableText(), StandardCharsets.UTF_8);
            try (OutputStream os = connection.getOutputStream();){
                byte[] input = encodedContent.getBytes(StandardCharsets.UTF_8);
                os.write(input, 0, input.length);
            }
            int responseCode = connection.getResponseCode();
            if (responseCode != 200) {
                this.getPlugin().getLogger().warning("Failed to upload to mclo.gs. Response code: " + responseCode);
                return null;
            }
            try (BufferedReader br = new BufferedReader(new InputStreamReader(connection.getInputStream(), StandardCharsets.UTF_8));){
                String responseLine;
                StringBuilder response = new StringBuilder();
                while ((responseLine = br.readLine()) != null) {
                    response.append(responseLine);
                }
                String string = this.parseMclogsResponse(response.toString());
                return string;
            }
        }
        catch (Exception e) {
            this.getPlugin().getLogger().log(Level.WARNING, "Failed to upload debug report", e);
        }
        return null;
    }

    private String parseMclogsResponse(String jsonResponse) {
        if (jsonResponse.contains("\"success\":true") && jsonResponse.contains("\"url\":\"")) {
            int urlStart = jsonResponse.indexOf("\"url\":\"") + 7;
            int urlEnd = jsonResponse.indexOf("\"", urlStart);
            return jsonResponse.substring(urlStart, urlEnd);
        }
        this.getPlugin().getLogger().warning("Invalid response from mclo.gs: " + jsonResponse);
        return null;
    }

    @Override
    public boolean isReady() {
        return true;
    }
}

