/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.util;

import com.zetaplugins.zetacore.util.LocationDeserializationException;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;

public final class LocationSerializer {
    public static final WorldProvider DEFAULT_PROVIDER = Bukkit::getWorld;

    private LocationSerializer() {
    }

    public static String serializeLocation(String worldName, double x, double y, double z, float yaw, float pitch) {
        return worldName + "," + x + "," + y + "," + z + "," + yaw + "," + pitch;
    }

    public static String serializeLocation(Location location) {
        return LocationSerializer.serializeLocation(location.getWorld().getName(), location.getX(), location.getY(), location.getZ(), location.getYaw(), location.getPitch());
    }

    public static Location deserializeLocation(String serializedLocation) throws LocationDeserializationException {
        return LocationSerializer.deserializeLocation(serializedLocation, DEFAULT_PROVIDER);
    }

    public static Location deserializeLocation(String serializedLocation, WorldProvider provider) throws LocationDeserializationException {
        if (serializedLocation.isEmpty()) {
            throw new LocationDeserializationException("Serialized location string is empty.");
        }
        String[] parts = serializedLocation.split(",");
        if (parts.length != 6) {
            throw new LocationDeserializationException("Invalid serialized location format. Expected 6 parts but got " + parts.length);
        }
        String worldName = parts[0];
        World world = provider.getWorld(worldName);
        if (world == null) {
            throw new LocationDeserializationException("World not found: " + worldName);
        }
        double x = Double.parseDouble(parts[1]);
        double y = Double.parseDouble(parts[2]);
        double z = Double.parseDouble(parts[3]);
        float yaw = Float.parseFloat(parts[4]);
        float pitch = Float.parseFloat(parts[5]);
        return new Location(world, x, y, z, yaw, pitch);
    }

    public static interface WorldProvider {
        public World getWorld(String var1);
    }
}

