/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.updatechecker;

import com.zetaplugins.zetacore.annotations.Manager;
import java.util.logging.Logger;
import org.bukkit.plugin.java.JavaPlugin;

@Manager
public abstract class UpdateChecker {
    private final JavaPlugin plugin;
    private final Logger logger;
    private boolean newVersionAvailable = false;
    private String latestVersion;

    public UpdateChecker(JavaPlugin plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public abstract void checkForUpdates(boolean var1);

    protected String getNewVersionConsoleMessage(String latestVersion, String currentVersion, String newVersionUrl) {
        String reset = "\u001b[0m";
        String bold = "\u001b[1m";
        String darkGray = "\u001b[90m";
        String lightGray = "\u001b[37m";
        String green = "\u001b[32m";
        return "\n\u001b[90m==========================================\u001b[0m\n\u001b[1mA new version of " + this.getPlugin().getName() + " is available!\u001b[0m\n\u001b[1mNew Version: \u001b[0m\u001b[1m\u001b[32m" + latestVersion + "\u001b[0m\u001b[37m (Your version: " + currentVersion + ")\u001b[0m\n\u001b[1mDownload here: \u001b[0m\u001b[37m\u001b[0m" + newVersionUrl + "\n\u001b[90m==========================================\u001b[0m";
    }

    protected void setNewVersionAvailable(boolean available) {
        this.newVersionAvailable = available;
    }

    public boolean isNewVersionAvailable() {
        return this.newVersionAvailable;
    }

    protected void setLatestVersion(String latestVersion) {
        this.latestVersion = latestVersion;
    }

    public String getLatestVersion() {
        return this.latestVersion;
    }

    public abstract String getLatestVersionUrl();

    protected JavaPlugin getPlugin() {
        return this.plugin;
    }

    protected Logger getLogger() {
        return this.logger;
    }
}

