/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.config;

import com.zetaplugins.zetacore.annotations.Manager;
import com.zetaplugins.zetacore.services.config.ConfigMapper;
import com.zetaplugins.zetacore.services.config.PluginConfigFile;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

@Manager
public class ConfigService {
    private final JavaPlugin plugin;
    private final Map<String, FileConfiguration> configCache;

    public ConfigService(JavaPlugin plugin) {
        this.plugin = plugin;
        this.configCache = new HashMap<String, FileConfiguration>();
    }

    public FileConfiguration getConfig(PluginConfigFile config) {
        return this.getFileConfigFromFileName(config.getFileName(), true);
    }

    public FileConfiguration getConfig(PluginConfigFile config, boolean useCache) {
        return this.getFileConfigFromFileName(config.getFileName(), useCache);
    }

    public FileConfiguration getConfig(String fileName) {
        return this.getFileConfigFromFileName(fileName, true);
    }

    public FileConfiguration getConfig(String fileName, boolean useCache) {
        return this.getFileConfigFromFileName(fileName, useCache);
    }

    public <T> T getConfig(Class<T> configClass) {
        return this.getConfig(configClass, true);
    }

    public <T> T getConfig(Class<T> configClass, boolean useCache) {
        String fileName = ConfigMapper.toFileName(configClass);
        FileConfiguration fileConfig = this.getConfig(fileName, useCache);
        if (fileConfig == null) {
            throw new IllegalStateException("Configuration file not found: " + fileName);
        }
        return ConfigMapper.map(fileConfig, configClass);
    }

    private FileConfiguration getFileConfigFromFileName(String fileName, boolean useCache) {
        if (useCache && this.configCache.containsKey(fileName)) {
            return this.configCache.get(fileName);
        }
        Object fileNameWithExtension = fileName.endsWith(".yml") ? fileName : fileName + ".yml";
        File configFile = new File(this.plugin.getDataFolder(), (String)fileNameWithExtension);
        if (!configFile.exists()) {
            configFile.getParentFile().mkdirs();
            this.plugin.saveResource((String)fileNameWithExtension, false);
        }
        YamlConfiguration fileConfig = YamlConfiguration.loadConfiguration((File)configFile);
        if (useCache) {
            this.configCache.put(fileName, (FileConfiguration)fileConfig);
        }
        return fileConfig;
    }

    public void saveConfig(PluginConfigFile config, FileConfiguration fileConfig) {
        this.saveFileConfigToFileName(config.getFileName(), fileConfig);
    }

    public void saveConfig(String fileName, FileConfiguration fileConfig) {
        this.saveFileConfigToFileName(fileName, fileConfig);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveFileConfigToFileName(String fileName, FileConfiguration fileConfig) {
        Object fileNameWithExtension = fileName.endsWith(".yml") ? fileName : fileName + ".yml";
        File configFile = new File(this.plugin.getDataFolder(), (String)fileNameWithExtension);
        try {
            fileConfig.save(configFile);
        }
        catch (Exception e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to save configuration file: " + fileName + ".yml", e);
        }
        finally {
            this.configCache.remove(fileName);
        }
    }

    public void clearCache() {
        this.configCache.clear();
    }
}

