/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.messages;

import com.zetaplugins.zetacore.annotations.Manager;
import com.zetaplugins.zetacore.services.localization.LocalizationService;
import com.zetaplugins.zetacore.services.messages.Replaceable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

@Manager
public abstract class BaseMessageService {
    protected final LocalizationService localizationService;
    protected final Map<String, String> colorMap;

    public BaseMessageService(LocalizationService localizationService) {
        this.localizationService = localizationService;
        this.colorMap = new HashMap<String, String>();
        this.colorMap.put("&0", "<black>");
        this.colorMap.put("&1", "<dark_blue>");
        this.colorMap.put("&2", "<dark_green>");
        this.colorMap.put("&3", "<dark_aqua>");
        this.colorMap.put("&4", "<dark_red>");
        this.colorMap.put("&5", "<dark_purple>");
        this.colorMap.put("&6", "<gold>");
        this.colorMap.put("&7", "<gray>");
        this.colorMap.put("&8", "<dark_gray>");
        this.colorMap.put("&9", "<blue>");
        this.colorMap.put("&a", "<green>");
        this.colorMap.put("&b", "<aqua>");
        this.colorMap.put("&c", "<red>");
        this.colorMap.put("&d", "<light_purple>");
        this.colorMap.put("&e", "<yellow>");
        this.colorMap.put("&f", "<white>");
        this.colorMap.put("&k", "<obfuscated>");
        this.colorMap.put("&l", "<bold>");
        this.colorMap.put("&m", "<strikethrough>");
        this.colorMap.put("&n", "<underlined>");
        this.colorMap.put("&o", "<italic>");
        this.colorMap.put("&r", "<reset>");
    }

    protected LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    public String getAccentColor() {
        return this.localizationService.getString("accentColor", "<#00D26A>");
    }

    @NotNull
    public String replacePlaceholders(String msg, Replaceable<?> ... replaceables) {
        StringBuilder msgBuilder = new StringBuilder(msg);
        for (Replaceable<?> replaceable : replaceables) {
            String placeholder = replaceable.placeholder();
            String value2 = String.valueOf(replaceable.value());
            this.replaceInBuilder(msgBuilder, placeholder, value2);
        }
        this.colorMap.forEach((key, value) -> this.replaceInBuilder(msgBuilder, (String)key, (String)value));
        return msgBuilder.toString();
    }

    @NotNull
    public String replacePlaceholdersWithAccentColors(String msg, Replaceable<?> ... replaceables) {
        String replacedMsg = this.replacePlaceholders(msg, replaceables);
        StringBuilder msgBuilder = new StringBuilder(replacedMsg);
        this.replaceInBuilder(msgBuilder, "%ac%", this.getAccentColor());
        return msgBuilder.toString();
    }

    protected void replaceInBuilder(StringBuilder builder, String placeholder, String replacement) {
        int index;
        while ((index = builder.indexOf(placeholder)) != -1) {
            builder.replace(index, index + placeholder.length(), replacement);
        }
    }

    public List<String> getRawMessageList(String path) {
        if (path.startsWith("messages.")) {
            path = path.substring("messages.".length());
        }
        return this.localizationService.getStringList(path);
    }

    public String getRawMessage(String path, String fallback, boolean addPrefix) {
        if (path.startsWith("messages.")) {
            path = path.substring("messages.".length());
        }
        String msg = this.localizationService.getString(path, fallback);
        String prefix = this.localizationService.getString("prefix", "&8[<gradient:#00D26A:#00B24F>TimberZ&8]");
        return !prefix.isEmpty() && addPrefix ? prefix + " " + msg : msg;
    }
}

