/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.localization;

import com.zetaplugins.zetacore.services.localization.LocalizationService;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

public final class BukkitLocalizationService
implements LocalizationService {
    private final JavaPlugin plugin;
    private final List<String> possibleLangs;
    private final String fallbackLang;
    private final String langFolder;
    private final String langConfigOption;
    private FileConfiguration langConfig;

    public BukkitLocalizationService(JavaPlugin plugin, List<String> possibleLangs) {
        this.plugin = plugin;
        this.possibleLangs = possibleLangs;
        this.fallbackLang = "en-US";
        this.langFolder = "lang/";
        this.langConfigOption = "lang";
        this.loadLanguageConfig();
    }

    public BukkitLocalizationService(JavaPlugin plugin, List<String> possibleLangs, String fallbackLang, String langFolder, String langConfigOption) {
        this.plugin = plugin;
        this.possibleLangs = possibleLangs;
        this.fallbackLang = fallbackLang;
        this.langFolder = langFolder;
        this.langConfigOption = langConfigOption;
        this.loadLanguageConfig();
    }

    public void reload() {
        this.loadLanguageConfig();
    }

    private void loadLanguageConfig() {
        File languageDirectory = new File(this.plugin.getDataFolder(), this.langFolder);
        if (!languageDirectory.exists() || !languageDirectory.isDirectory()) {
            languageDirectory.mkdir();
        }
        for (String langString : this.possibleLangs) {
            File langFile = new File(this.langFolder, langString + ".yml");
            if (new File(languageDirectory, langString + ".yml").exists()) continue;
            this.plugin.getLogger().info("Saving file " + langFile.getPath());
            this.plugin.saveResource(langFile.getPath(), false);
        }
        String langOption = this.plugin.getConfig().getString(this.langConfigOption, this.fallbackLang);
        File selectedLangFile = new File(languageDirectory, langOption + ".yml");
        if (!selectedLangFile.exists()) {
            selectedLangFile = new File(languageDirectory, this.fallbackLang + ".yml");
            this.plugin.getLogger().warning("Language file " + langOption + ".yml (" + selectedLangFile.getPath() + ") not found! Using fallback " + this.fallbackLang + ".yml.");
        }
        this.plugin.getLogger().info("Using language file: " + selectedLangFile.getPath());
        this.langConfig = YamlConfiguration.loadConfiguration((File)selectedLangFile);
    }

    @Override
    public String getString(String key) {
        return this.langConfig.getString(key);
    }

    @Override
    public String getString(String key, String fallback) {
        return this.langConfig.getString(key) != null ? this.langConfig.getString(key) : fallback;
    }

    @Override
    public List<String> getStringList(String key) {
        return this.langConfig.getStringList(key);
    }
}

