/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services;

import com.zetaplugins.zetacore.services.localization.LocalizationService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;
import org.jetbrains.annotations.NotNull;

public class MessageService {
    private final LocalizationService localizationService;
    private final Map<String, String> colorMap;

    public MessageService(LocalizationService localizationService) {
        this.localizationService = localizationService;
        this.colorMap = new HashMap<String, String>();
        this.colorMap.put("&0", "<black>");
        this.colorMap.put("&1", "<dark_blue>");
        this.colorMap.put("&2", "<dark_green>");
        this.colorMap.put("&3", "<dark_aqua>");
        this.colorMap.put("&4", "<dark_red>");
        this.colorMap.put("&5", "<dark_purple>");
        this.colorMap.put("&6", "<gold>");
        this.colorMap.put("&7", "<gray>");
        this.colorMap.put("&8", "<dark_gray>");
        this.colorMap.put("&9", "<blue>");
        this.colorMap.put("&a", "<green>");
        this.colorMap.put("&b", "<aqua>");
        this.colorMap.put("&c", "<red>");
        this.colorMap.put("&d", "<light_purple>");
        this.colorMap.put("&e", "<yellow>");
        this.colorMap.put("&f", "<white>");
        this.colorMap.put("&k", "<obfuscated>");
        this.colorMap.put("&l", "<bold>");
        this.colorMap.put("&m", "<strikethrough>");
        this.colorMap.put("&n", "<underlined>");
        this.colorMap.put("&o", "<italic>");
        this.colorMap.put("&r", "<reset>");
    }

    protected LocalizationService getLocalizationService() {
        return this.localizationService;
    }

    public Component formatMsg(String msg, Replaceable<?> ... replaceables) {
        msg = this.replacePlaceholders(msg, replaceables);
        MiniMessage mm = MiniMessage.miniMessage();
        return mm.deserialize((Object)("<!i>" + msg));
    }

    public Component getAndFormatMsg(boolean addPrefix, String path, String fallback, Replaceable<?> ... replaceables) {
        if (path.startsWith("messages.")) {
            path = path.substring("messages.".length());
        }
        MiniMessage mm = MiniMessage.miniMessage();
        Object msg = "<!i>" + this.localizationService.getString(path, fallback);
        String prefix = this.localizationService.getString("prefix", "&8[<gradient:#00D26A:#00B24F>TimberZ&8]");
        msg = !prefix.isEmpty() && addPrefix ? prefix + " " + (String)msg : msg;
        msg = this.replacePlaceholdersWithAccentColors((String)msg, replaceables);
        return mm.deserialize(msg);
    }

    public List<Component> getAndFormatMsgList(String path, Replaceable<?> ... replaceables) {
        if (path.startsWith("messages.")) {
            path = path.substring("messages.".length());
        }
        MiniMessage mm = MiniMessage.miniMessage();
        List<String> msgList = this.localizationService.getStringList(path);
        ArrayList<Component> components = new ArrayList<Component>();
        for (String string : msgList) {
            Object msg = "<!i>" + string;
            msg = this.replacePlaceholdersWithAccentColors((String)msg, replaceables);
            components.add(mm.deserialize(msg));
        }
        return components;
    }

    public String getAccentColor() {
        return this.localizationService.getString("accentColor", "<#00D26A>");
    }

    @NotNull
    public String replacePlaceholders(String msg, Replaceable<?> ... replaceables) {
        StringBuilder msgBuilder = new StringBuilder(msg);
        for (Replaceable<?> replaceable : replaceables) {
            String placeholder = replaceable.placeholder();
            String value2 = String.valueOf(replaceable.value());
            this.replaceInBuilder(msgBuilder, placeholder, value2);
        }
        this.colorMap.forEach((key, value) -> this.replaceInBuilder(msgBuilder, (String)key, (String)value));
        return msgBuilder.toString();
    }

    @NotNull
    public String replacePlaceholdersWithAccentColors(String msg, Replaceable<?> ... replaceables) {
        String replacedMsg = this.replacePlaceholders(msg, replaceables);
        StringBuilder msgBuilder = new StringBuilder(replacedMsg);
        this.replaceInBuilder(msgBuilder, "%ac%", this.getAccentColor());
        return msgBuilder.toString();
    }

    protected void replaceInBuilder(StringBuilder builder, String placeholder, String replacement) {
        int index;
        while ((index = builder.indexOf(placeholder)) != -1) {
            builder.replace(index, index + placeholder.length(), replacement);
        }
    }

    public record Replaceable<T>(String placeholder, T value) {
    }
}

