/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.lifestealz.listeners;

import com.zetaplugins.lifestealz.LifeStealZ;
import com.zetaplugins.lifestealz.storage.PlayerData;
import com.zetaplugins.lifestealz.util.GuiManager;
import com.zetaplugins.lifestealz.util.MessageUtils;
import com.zetaplugins.lifestealz.util.WebHookManager;
import com.zetaplugins.lifestealz.util.commands.CommandUtils;
import com.zetaplugins.lifestealz.util.customblocks.CustomBlock;
import com.zetaplugins.lifestealz.util.customitems.CustomItemManager;
import com.zetaplugins.lifestealz.util.customitems.customitemdata.CustomReviveBeaconItemData;
import com.zetaplugins.lifestealz.util.revive.ReviveTask;
import java.util.List;
import java.util.UUID;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.HumanEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.inventory.InventoryClickEvent;
import org.bukkit.inventory.Inventory;
import org.bukkit.inventory.ItemStack;
import org.bukkit.persistence.PersistentDataType;
import org.bukkit.plugin.Plugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.scheduler.BukkitTask;

public final class InventoryClickListener
implements Listener {
    private final LifeStealZ plugin;

    public InventoryClickListener(LifeStealZ plugin) {
        this.plugin = plugin;
    }

    @EventHandler
    public void onInventoryClick(InventoryClickEvent event) {
        Inventory openInventory;
        Player player = (Player)event.getWhoClicked();
        if (this.handleRecipeGuiClick(event, player, openInventory = player.getOpenInventory().getTopInventory())) {
            return;
        }
        if (this.handleReviveGuiClick(event, player, openInventory)) {
            return;
        }
        if (this.handleBeaconReviveGuiClick(event, player, openInventory)) {
            return;
        }
        if (event.getCurrentItem() != null && CustomItemManager.isForbiddenItem(event.getCurrentItem())) {
            event.setCancelled(true);
            event.setCurrentItem(new ItemStack(Material.AIR));
        }
    }

    private boolean handleRecipeGuiClick(InventoryClickEvent event, Player player, Inventory openInventory) {
        if (!openInventory.equals((Object)GuiManager.RECIPE_GUI_MAP.get(player.getUniqueId()))) {
            return false;
        }
        event.setCancelled(true);
        ItemStack currentItem = event.getCurrentItem();
        if (currentItem != null && currentItem.getType() == Material.BARRIER) {
            player.closeInventory();
        }
        return true;
    }

    private boolean handleReviveGuiClick(InventoryClickEvent event, Player player, Inventory openInventory) {
        if (!openInventory.equals((Object)GuiManager.REVIVE_GUI_MAP.get(player.getUniqueId()))) {
            return false;
        }
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() == Material.AIR) {
            return true;
        }
        switch (item.getType()) {
            case BARRIER: {
                player.closeInventory();
                break;
            }
            case ARROW: {
                GuiManager.openReviveGui(player, this.getPageFromItem(item));
                break;
            }
            case PLAYER_HEAD: {
                this.handleReviveClick(item, player, false);
                break;
            }
            case SKELETON_SKULL: {
                this.handleReviveClick(item, player, true);
            }
        }
        return true;
    }

    private boolean handleBeaconReviveGuiClick(InventoryClickEvent event, Player player, Inventory openInventory) {
        if (!openInventory.equals((Object)GuiManager.REVIVE_BEACON_GUI_MAP.get(player.getUniqueId()))) {
            return false;
        }
        Location beaconLocation = GuiManager.REVIVE_BEACON_INVENTORY_LOCATIONS.get(player.getUniqueId());
        if (beaconLocation == null) {
            player.sendMessage((Component)Component.text((String)"\u00a7cAn error occurred while fetching the beacon location! Please try again."));
            return false;
        }
        event.setCancelled(true);
        ItemStack item = event.getCurrentItem();
        if (item == null || item.getType() == Material.AIR) {
            return true;
        }
        switch (item.getType()) {
            case BARRIER: {
                player.closeInventory();
                break;
            }
            case ARROW: {
                GuiManager.openReviveBeaconGui(player, this.getPageFromItem(item), this.plugin, beaconLocation);
                break;
            }
            case PLAYER_HEAD: {
                this.handleBeaconReviveClick(item, player, false, beaconLocation);
                break;
            }
            case SKELETON_SKULL: {
                this.handleBeaconReviveClick(item, player, true, beaconLocation);
            }
        }
        return true;
    }

    private void handleReviveClick(ItemStack item, Player player, boolean bedrock) {
        if (!player.hasPermission("lifestealz.revive")) {
            this.throwPermissionError((HumanEntity)player);
            return;
        }
        String uuidString = this.getLastLineOfLore(item, bedrock);
        if (uuidString == null) {
            return;
        }
        UUID uuid = UUID.fromString(uuidString);
        OfflinePlayer target = Bukkit.getServer().getOfflinePlayer(uuid);
        if (target.getName() == null) {
            player.sendMessage((Component)Component.text((String)"\u00a7cAn error occurred while fetching playerdata! Are you sure this is a real player?"));
            return;
        }
        if (!this.hasReviveCrystal(player)) {
            this.plugin.getLogger().warning("Player " + player.getName() + " tried to revive " + target.getName() + " without a revive crystal!");
            return;
        }
        this.revivePlayer(player, target, bedrock);
    }

    private void handleBeaconReviveClick(ItemStack item, Player player, boolean bedrock, Location beaconLocation) {
        if (!player.hasPermission("lifestealz.revive")) {
            this.throwPermissionError((HumanEntity)player);
            return;
        }
        if (this.plugin.getReviveTaskManager().isReviving(beaconLocation)) {
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "reviveBeaconAlreadyInUse", "&cThis revive beacon is already in use! Please wait until the current revive is finished.", new MessageUtils.Replaceable[0]));
            return;
        }
        String uuidString = this.getLastLineOfLore(item, bedrock);
        if (uuidString == null) {
            return;
        }
        UUID uuid = UUID.fromString(uuidString);
        OfflinePlayer target = Bukkit.getServer().getOfflinePlayer(uuid);
        if (target.getName() == null) {
            player.sendMessage((Component)Component.text((String)"\u00a7cAn error occurred while fetching playerdata! Are you sure this is a real player?"));
            return;
        }
        boolean targetReviving = this.plugin.getReviveTaskManager().isRevivingTarget(target.getUniqueId());
        if (targetReviving) {
            player.sendMessage(MessageUtils.getAndFormatMsg(false, "alreadyRevivingPlayer", "&cThis player is already being revived by another beacon! Please wait until the current revive is finished.", new MessageUtils.Replaceable[0]));
            player.playSound(player.getLocation(), Sound.ENTITY_VILLAGER_NO, 1.0f, 1.0f);
            player.closeInventory();
            return;
        }
        this.beaconRevivePlayer(player, target, bedrock, beaconLocation);
    }

    private boolean canRevivePlayer(Player reviver, OfflinePlayer target, PlayerData data) {
        int reviveMaximum = this.plugin.getConfig().getInt("maxRevives");
        int minHearts = this.plugin.getConfig().getInt("minHearts");
        if (reviveMaximum != -1 && data.getHasBeenRevived() >= reviveMaximum) {
            reviver.sendMessage(MessageUtils.getAndFormatMsg(false, "reviveMaxReached", "&cThis player has already been revived %amount% times!", new MessageUtils.Replaceable("%amount%", String.valueOf(data.getHasBeenRevived()))));
            return false;
        }
        if (data.getMaxHealth() > (double)(minHearts * 2)) {
            reviver.sendMessage(MessageUtils.getAndFormatMsg(false, "onlyReviveElimPlayers", "&cYou can only revive eliminated players!", new MessageUtils.Replaceable[0]));
            return false;
        }
        return true;
    }

    private void applyReviveData(PlayerData data) {
        data.setMaxHealth(this.plugin.getConfig().getInt("reviveHearts") * 2);
        data.setHasBeenRevived(data.getHasBeenRevived() + 1);
        this.plugin.getStorage().save(data);
    }

    private void executeReviveActions(Player reviver, OfflinePlayer target, String[] location) {
        this.plugin.getEliminatedPlayersCache().removeEliminatedPlayer(target.getName());
        reviver.sendMessage(MessageUtils.getAndFormatMsg(true, "reviveSuccess", "&7You successfully revived &c%player%&7!", new MessageUtils.Replaceable("%player%", target.getName())));
        reviver.playSound(reviver.getLocation(), Sound.ENTITY_PLAYER_LEVELUP, 500.0f, 1.0f);
        for (String command : this.plugin.getConfig().getStringList("reviveuseCommands")) {
            String finalCommand = command.replace("&player&", reviver.getName()).replace("&target&", target.getName()).replace("&location&", location[0] + ", " + location[1] + ", " + location[2]).replace("&locationX&", location[0]).replace("&locationY&", location[1]).replace("&locationZ&", location[2]);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand);
        }
        this.plugin.getWebHookManager().sendWebhookMessage(WebHookManager.WebHookType.REVIVE, target.getName(), reviver.getName());
    }

    private void revivePlayer(Player reviver, OfflinePlayer target, boolean isBedrock) {
        PlayerData data = this.plugin.getStorage().load(target.getUniqueId());
        if (!this.canRevivePlayer(reviver, target, data)) {
            return;
        }
        String[] locationNull = new String[]{"null", "null", "null"};
        this.applyReviveData(data);
        this.executeReviveActions(reviver, target, locationNull);
        this.removeReviveCrystal(reviver);
        reviver.closeInventory();
    }

    private void beaconRevivePlayer(final Player reviver, final OfflinePlayer target, boolean isBedrock, final Location beaconLocation) {
        CustomReviveBeaconItemData itemData;
        final PlayerData data = this.plugin.getStorage().load(target.getUniqueId());
        String customItemId = CustomBlock.REVIVE_BEACON.getCustomItemId(beaconLocation.getBlock());
        try {
            itemData = new CustomReviveBeaconItemData(customItemId);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        if (!this.canRevivePlayer(reviver, target, data)) {
            return;
        }
        final String[] location = new String[]{String.valueOf(beaconLocation.getBlockX()), String.valueOf(beaconLocation.getBlockY()), String.valueOf(beaconLocation.getBlockZ())};
        reviver.sendMessage(MessageUtils.getAndFormatMsg(true, "reviveBeaconStart", "&c%player% &7will be revived in &c%seconds% seconds&7! Please wait...", new MessageUtils.Replaceable("%player%", target.getName()), new MessageUtils.Replaceable("%seconds%", String.valueOf(itemData.getReviveTime()))));
        reviver.closeInventory();
        for (String command : this.plugin.getConfig().getStringList("reviveStartCommands")) {
            String finalCommand = command.replace("&player&", reviver.getName()).replace("&target&", target.getName()).replace("&location&", location[0] + ", " + location[1] + ", " + location[2]).replace("&locationX&", location[0]).replace("&locationY&", location[1]).replace("&locationZ&", location[2]);
            Bukkit.dispatchCommand((CommandSender)Bukkit.getConsoleSender(), (String)finalCommand);
        }
        this.plugin.getReviveBeaconEffectManager().startRevivingEffects(beaconLocation, target.getName(), itemData.shouldShowLaser(), itemData.shouldShowParticleRing(), itemData.getParticleColor(), itemData.getInnerLaser(), itemData.getOuterLaser(), itemData.getReviveTime());
        BukkitTask reviveTask = new BukkitRunnable(){

            public void run() {
                InventoryClickListener.this.applyReviveData(data);
                InventoryClickListener.this.executeReviveActions(reviver, target, location);
                InventoryClickListener.this.plugin.getReviveTaskManager().removeReviveTask(beaconLocation);
                InventoryClickListener.this.plugin.getReviveBeaconEffectManager().clearAllEffects(beaconLocation);
                beaconLocation.getBlock().setType(Material.AIR);
                beaconLocation.getWorld().playSound(beaconLocation, Sound.ENTITY_PLAYER_LEVELUP, 500.0f, 1.0f);
            }
        }.runTaskLater((Plugin)this.plugin, (long)itemData.getReviveTime() * 20L);
        this.plugin.getReviveTaskManager().addReviveTask(beaconLocation, new ReviveTask(beaconLocation, reviveTask, reviver.getUniqueId(), target.getUniqueId(), System.currentTimeMillis() / 1000L, itemData.getReviveTime()));
    }

    private int getPageFromItem(ItemStack item) {
        Integer pageInt = (Integer)item.getItemMeta().getPersistentDataContainer().get(CustomItemManager.REVIVE_PAGE_KEY, PersistentDataType.INTEGER);
        return pageInt != null ? pageInt : 1;
    }

    private void throwPermissionError(HumanEntity player) {
        CommandUtils.throwPermissionError((CommandSender)player);
    }

    private String getLastLineOfLore(ItemStack item, boolean bedrock) {
        PlainTextComponentSerializer plainSerializer = PlainTextComponentSerializer.plainText();
        List lore = item.lore();
        if (lore == null || lore.size() < (bedrock ? 2 : 1)) {
            return null;
        }
        int line = bedrock ? 2 : 1;
        Component lastLore = (Component)lore.get(lore.size() - line);
        return plainSerializer.serialize(lastLore);
    }

    private boolean hasReviveCrystal(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !CustomItemManager.isReviveItem(item)) continue;
            return true;
        }
        return false;
    }

    private void removeReviveCrystal(Player player) {
        for (ItemStack item : player.getInventory().getContents()) {
            if (item == null || !CustomItemManager.isReviveItem(item)) continue;
            item.setAmount(item.getAmount() - 1);
            return;
        }
    }
}

