/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.debug.data;

import com.zetaplugins.zetacore.debug.data.InstalledPlugin;
import com.zetaplugins.zetacore.debug.data.JsonSeriaizable;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public record DebugReport(String modrinthId, long timestamp, String pluginName, String pluginVersion, String pluginHash, String minecraftVersion, String javaVersion, String serverSoftware, String osName, String osVersion, String latestLogs, Set<InstalledPlugin> installedPlugins, Map<String, String> configurations) implements JsonSeriaizable
{
    @Override
    public JSONObject toJson() {
        JSONObject json = new JSONObject();
        json.put((Object)"timestamp", (Object)this.timestamp);
        json.put((Object)"modrinthId", (Object)this.modrinthId);
        json.put((Object)"pluginName", (Object)this.pluginName);
        json.put((Object)"pluginVersion", (Object)this.pluginVersion);
        json.put((Object)"pluginHash", (Object)this.pluginHash);
        json.put((Object)"minecraftVersion", (Object)this.minecraftVersion);
        json.put((Object)"javaVersion", (Object)this.javaVersion);
        json.put((Object)"serverSoftware", (Object)this.serverSoftware);
        json.put((Object)"osName", (Object)this.osName);
        json.put((Object)"osVersion", (Object)this.osVersion);
        json.put((Object)"latestLogs", (Object)this.latestLogs);
        JSONArray pluginsArray = new JSONArray();
        for (InstalledPlugin plugin : this.installedPlugins) {
            if (plugin == null) continue;
            pluginsArray.add((Object)plugin.toJson());
        }
        json.put((Object)"installedPlugins", (Object)pluginsArray);
        JSONObject configJson = new JSONObject();
        if (this.configurations != null) {
            configJson.putAll(this.configurations);
        }
        json.put((Object)"configurations", (Object)configJson);
        return json;
    }

    public String toJsonString() {
        return this.toJson().toString();
    }

    public String toReadableText() {
        StringBuilder res = new StringBuilder();
        res.append("---- LifeStealZ Debug Dump ----").append("\n");
        res.append("This is an automatically generated debug report").append("\n");
        res.append("Timestamp: ").append(this.timestamp).append("\n\n");
        res.append("-- Plugin Details --").append("\n");
        res.append("Plugin Name: ").append(this.pluginName).append("\n");
        res.append("Plugin Version: ").append(this.pluginVersion).append("\n");
        res.append("Plugin Hash: ").append(this.pluginHash).append("\n");
        res.append("Minecraft Version: ").append(this.minecraftVersion).append("\n");
        res.append("Java Version: ").append(this.javaVersion).append("\n");
        res.append("Server Software: ").append(this.serverSoftware).append("\n");
        res.append("OS: ").append(this.osName).append(" ").append(this.osVersion).append("\n\n");
        res.append("-- Installed Plugins --").append("\n");
        if (this.installedPlugins.isEmpty()) {
            res.append("No plugins installed.").append("\n");
        } else {
            for (InstalledPlugin installedPlugin : this.installedPlugins) {
                res.append(installedPlugin.toString()).append("\n");
            }
        }
        res.append("\n-- Configurations --").append("\n");
        if (this.configurations == null || this.configurations.isEmpty()) {
            res.append("No configurations found.").append("\n");
        } else {
            for (Map.Entry entry : this.configurations.entrySet()) {
                res.append((String)entry.getKey()).append(": ").append("\n---").append((String)entry.getValue()).append("\n---").append("\n");
            }
        }
        res.append("\n");
        res.append("-- Latest Logs --").append("\n");
        res.append(this.latestLogs).append("\n\n");
        res.append("---- End of Debug Dump ----").append("\n");
        return res.toString();
    }

    @Override
    public String toString() {
        return "DebugData{timestamp=" + this.timestamp + ", pluginName='" + this.pluginName + "', pluginVersion='" + this.pluginVersion + "', pluginHash='" + this.pluginHash + "', minecraftVersion='" + this.minecraftVersion + "', javaVersion='" + this.javaVersion + "', serverSoftware='" + this.serverSoftware + "', osName='" + this.osName + "', osVersion='" + this.osVersion + "', latestLogs='" + this.latestLogs + "', installedPlugins=[" + this.installedPlugins.stream().map(InstalledPlugin::toString).collect(Collectors.joining(", ")) + "], configurations=" + String.valueOf(this.configurations) + "}";
    }
}

