/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.serverlinksz.util;

import com.zetaplugins.serverlinksz.ServerLinksZ;
import java.util.HashMap;
import java.util.Map;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.minimessage.MiniMessage;

public class MessageUtils {
    private static final Map<String, String> colorMap = new HashMap<String, String>();

    private MessageUtils() {
    }

    public static Component formatMsg(String msg, Replaceable ... replaceables) {
        for (Replaceable replaceable : replaceables) {
            msg = msg.replace(replaceable.placeholder(), replaceable.value());
        }
        for (Map.Entry entry : colorMap.entrySet()) {
            msg = msg.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        MiniMessage mm = MiniMessage.miniMessage();
        return mm.deserialize((Object)("<!i>" + msg));
    }

    public static Component getAndFormatMsg(boolean addPrefix, String path, String fallback, Replaceable ... replaceables) {
        if (path.startsWith("messages.")) {
            path = path.substring("messages.".length());
        }
        MiniMessage mm = MiniMessage.miniMessage();
        Object msg = "<!i>" + ServerLinksZ.getInstance().getLanguageManager().getString(path, fallback);
        String prefix = ServerLinksZ.getInstance().getLanguageManager().getString("prefix", "&8[&cServerLinksZ&8]");
        if (addPrefix) {
            msg = prefix + " " + (String)msg;
        }
        for (Replaceable replaceable : replaceables) {
            msg = ((String)msg).replace(replaceable.placeholder(), replaceable.value());
        }
        for (Map.Entry entry : colorMap.entrySet()) {
            msg = ((String)msg).replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return mm.deserialize(msg);
    }

    static {
        colorMap.put("&0", "<black>");
        colorMap.put("&1", "<dark_blue>");
        colorMap.put("&2", "<dark_green>");
        colorMap.put("&3", "<dark_aqua>");
        colorMap.put("&4", "<dark_red>");
        colorMap.put("&5", "<dark_purple>");
        colorMap.put("&6", "<gold>");
        colorMap.put("&7", "<gray>");
        colorMap.put("&8", "<dark_gray>");
        colorMap.put("&9", "<blue>");
        colorMap.put("&a", "<green>");
        colorMap.put("&b", "<aqua>");
        colorMap.put("&c", "<red>");
        colorMap.put("&d", "<light_purple>");
        colorMap.put("&e", "<yellow>");
        colorMap.put("&f", "<white>");
        colorMap.put("&k", "<obfuscated>");
        colorMap.put("&l", "<bold>");
        colorMap.put("&m", "<strikethrough>");
        colorMap.put("&n", "<underline>");
        colorMap.put("&o", "<italic>");
        colorMap.put("&r", "<reset>");
    }

    public record Replaceable(String placeholder, String value) {
    }
}

