/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.serverlinksz.util;

import com.zetaplugins.serverlinksz.ServerLinksZ;
import com.zetaplugins.serverlinksz.commands.LinkCommand;
import com.zetaplugins.serverlinksz.util.MessageUtils;
import java.io.File;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.bukkit.Bukkit;
import org.bukkit.ServerLinks;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.command.defaults.BukkitCommand;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LinkManager {
    private final ServerLinksZ plugin;
    private final ServerLinks serverLinks = Bukkit.getServer().getServerLinks();
    private final Logger logger;

    public LinkManager(ServerLinksZ plugin) {
        this.plugin = plugin;
        this.logger = plugin.getLogger();
    }

    public void updateLinks() {
        FileConfiguration config = this.getLinksConfig();
        this.clearLinks();
        for (String key : config.getKeys(false)) {
            String name = config.getString(key + ".name");
            String url = config.getString(key + ".url");
            String type = config.getString(key + ".type");
            if (name == null || url == null) continue;
            this.registerLink(name, url, type);
        }
    }

    private void registerLink(String name, String url, @Nullable String typeString) {
        try {
            URI uri = new URI(url);
            ServerLinks.Type type = this.getLinkType(typeString);
            if (type != null) {
                this.serverLinks.addLink(type, uri);
            } else {
                this.serverLinks.addLink(MessageUtils.formatMsg(name, new MessageUtils.Replaceable[0]), uri);
            }
        }
        catch (URISyntaxException e) {
            this.logger.warning("Invalid URL: " + url);
            throw new RuntimeException(e);
        }
    }

    private ServerLinks.Type getLinkType(String name) {
        if (name == null) {
            return null;
        }
        try {
            return ServerLinks.Type.valueOf((String)name.toUpperCase());
        }
        catch (IllegalArgumentException | NullPointerException e) {
            return null;
        }
    }

    public void addLink(String key, String name, String url, boolean command, String stringType) {
        FileConfiguration config = this.getLinksConfig();
        ServerLinks.Type type = this.getLinkType(stringType);
        String typeToSave = type != null ? type.toString() : "CUSTOM";
        config.set(key + ".name", (Object)name);
        config.set(key + ".url", (Object)url);
        config.set(key + ".allowCommand", (Object)command);
        config.set(key + ".type", (Object)typeToSave);
        this.saveLinksConfig(config);
        this.updateLinks();
    }

    public void removeLink(String key) {
        FileConfiguration config = this.getLinksConfig();
        config.set(key, null);
        this.saveLinksConfig(config);
        this.updateLinks();
    }

    public void clearLinks() {
        for (ServerLinks.ServerLink link : this.serverLinks.getLinks()) {
            this.serverLinks.removeLink(link);
        }
    }

    @Nullable
    public Link getLink(String key) {
        FileConfiguration config = this.getLinksConfig();
        String name = config.getString(key + ".name");
        String url = config.getString(key + ".url");
        boolean allowCommand = config.getBoolean(key + ".allowCommand");
        if (name == null || url == null) {
            return null;
        }
        return new Link(key, name, url, allowCommand, this.plugin);
    }

    public Set<String> getLinkKeys() {
        return this.getLinksConfig().getKeys(false);
    }

    public Set<String> getLinkKeys(Predicate<Link> predicate) {
        return this.getLinkKeys().stream().filter(key -> {
            Link link = this.getLink((String)key);
            return link != null && predicate.test(link);
        }).collect(Collectors.toSet());
    }

    private FileConfiguration getLinksConfig() {
        File linksFile = new File(this.plugin.getDataFolder(), "links.yml");
        if (!linksFile.exists()) {
            linksFile.getParentFile().mkdirs();
            this.plugin.saveResource("links.yml", false);
        }
        return YamlConfiguration.loadConfiguration((File)linksFile);
    }

    private void saveLinksConfig(FileConfiguration config) {
        File linksFile = new File(this.plugin.getDataFolder(), "links.yml");
        try {
            config.save(linksFile);
        }
        catch (Exception e) {
            this.logger.severe("Failed to save links.yml!");
            e.printStackTrace();
        }
    }

    public record Link(String id, String name, String url, boolean allowCommand, ServerLinksZ plugin) {
        @NotNull
        public Command getCommand() {
            final LinkCommand executor = new LinkCommand(this.plugin);
            return new BukkitCommand(this, this.id()){

                public boolean execute(@NotNull CommandSender sender, @NotNull String commandLabel, String[] args) {
                    return executor.onCommand(sender, (Command)this, commandLabel, args);
                }

                @NotNull
                public List<String> tabComplete(@NotNull CommandSender sender, @NotNull String alias, String[] args) throws IllegalArgumentException {
                    List<String> completions = executor.onTabComplete(sender, (Command)this, alias, args);
                    return completions == null ? List.of() : completions;
                }
            };
        }
    }
}

