/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.serverlinksz.util;

import com.zetaplugins.serverlinksz.ServerLinksZ;
import com.zetaplugins.serverlinksz.commands.LinkCommand;
import com.zetaplugins.serverlinksz.commands.maincommand.MainCommandHandler;
import com.zetaplugins.serverlinksz.commands.maincommand.MainTabCompleter;
import com.zetaplugins.serverlinksz.util.LinkManager;
import com.zetaplugins.serverlinksz.util.MessageUtils;
import com.zetaplugins.zetacore.debug.command.DebugCommandHandler;
import java.io.File;
import java.lang.reflect.Field;
import java.util.HashMap;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandMap;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;

public class CommandManager {
    private final ServerLinksZ plugin;

    public CommandManager(ServerLinksZ plugin) {
        this.plugin = plugin;
    }

    private CommandMap getCommandMap() {
        try {
            Field field = Bukkit.getServer().getClass().getDeclaredField("commandMap");
            field.setAccessible(true);
            return (CommandMap)field.get(Bukkit.getServer());
        }
        catch (Exception e) {
            this.plugin.getLogger().severe("Failed to get command map: " + e.getMessage());
            return null;
        }
    }

    public void registerCommands() {
        CommandMap commandMap;
        this.registerCommand("serverlinksz", new MainCommandHandler(this.plugin), new MainTabCompleter(this.plugin));
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("config.yml", this.plugin.getConfig().saveToString());
        configs.put("links.yml", this.getLinksConfig().saveToString());
        DebugCommandHandler debugCommandHandler = new DebugCommandHandler("iR9qgF1M", this.plugin, this.plugin.getPluginFile(), "serverlinksz.admin", configs);
        this.registerCommand("slzdebug", debugCommandHandler, debugCommandHandler);
        if (this.plugin.getConfig().getBoolean("linkCommand")) {
            this.registerCommand("link", new LinkCommand(this.plugin), new LinkCommand(this.plugin));
        }
        if ((commandMap = this.getCommandMap()) == null) {
            return;
        }
        for (String linkKey : this.plugin.getLinkManager().getLinkKeys()) {
            LinkManager.Link link = this.plugin.getLinkManager().getLink(linkKey);
            if (link == null || !link.allowCommand()) continue;
            commandMap.register(linkKey, "slzcmd", link.getCommand());
        }
    }

    private void registerCommand(String name, CommandExecutor executor, TabCompleter tabCompleter) {
        PluginCommand command = this.plugin.getCommand(name);
        if (command != null) {
            command.setExecutor(executor);
            command.setTabCompleter(tabCompleter);
            command.permissionMessage(MessageUtils.getAndFormatMsg(false, "noPermissionError", "&cYou don't have permission to use this!", new MessageUtils.Replaceable[0]));
        }
    }

    private FileConfiguration getLinksConfig() {
        File linksFile = new File(this.plugin.getDataFolder(), "links.yml");
        if (!linksFile.exists()) {
            linksFile.getParentFile().mkdirs();
            this.plugin.saveResource("links.yml", false);
        }
        return YamlConfiguration.loadConfiguration((File)linksFile);
    }
}

