/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.serverlinksz.commands.maincommand.subcommands;

import com.zetaplugins.serverlinksz.ServerLinksZ;
import com.zetaplugins.serverlinksz.commands.CommandUtils;
import com.zetaplugins.serverlinksz.commands.SubCommand;
import com.zetaplugins.serverlinksz.util.MessageUtils;
import org.bukkit.command.CommandSender;

public class RemoveSubCommand
implements SubCommand {
    private final ServerLinksZ plugin;

    public RemoveSubCommand(ServerLinksZ plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender)) {
            CommandUtils.throwPermissionError(sender);
            return false;
        }
        if (args.length < 2) {
            CommandUtils.throwUsageError(sender, this.getUsage());
            return false;
        }
        boolean showHints = this.plugin.getConfig().getBoolean("hints");
        String id = args[1];
        boolean linkExists = this.plugin.getLinkManager().getLinkKeys().contains(id);
        if (!linkExists) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "linkNotFound", "&cLink with id %id%&c not found!", new MessageUtils.Replaceable("%id%", id)));
            return false;
        }
        this.plugin.getLinkManager().removeLink(id);
        sender.sendMessage(MessageUtils.getAndFormatMsg(true, "removeLinkMsg", "&7Successfully removed link with id %id%!", new MessageUtils.Replaceable("%id%", id)));
        if (showHints) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "rejoinHint", "<#E9D502>\u26a0 To update the Serverlinks, please rejoin the server!", new MessageUtils.Replaceable[0]));
        }
        return true;
    }

    @Override
    public String getUsage() {
        return "/serverlinksz remove <id>";
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("serverlinksz.admin");
    }
}

