/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.serverlinksz.commands.maincommand.subcommands;

import com.zetaplugins.serverlinksz.ServerLinksZ;
import com.zetaplugins.serverlinksz.commands.CommandUtils;
import com.zetaplugins.serverlinksz.commands.SubCommand;
import com.zetaplugins.serverlinksz.util.MessageUtils;
import org.bukkit.command.CommandSender;

public class ReloadSubCommand
implements SubCommand {
    private final ServerLinksZ plugin;

    public ReloadSubCommand(ServerLinksZ plugin) {
        this.plugin = plugin;
    }

    @Override
    public boolean execute(CommandSender sender, String[] args) {
        if (!this.hasPermission(sender)) {
            CommandUtils.throwPermissionError(sender);
            return false;
        }
        boolean showHints = this.plugin.getConfig().getBoolean("hints");
        this.plugin.reloadConfig();
        this.plugin.getLanguageManager().reload();
        this.plugin.getLinkManager().updateLinks();
        sender.sendMessage(MessageUtils.getAndFormatMsg(true, "reloadMsg", "&7Successfully reloaded the plugin!", new MessageUtils.Replaceable[0]));
        if (showHints) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "restartServerToRegisterCustomCommands", "<#E9D502>\u26a0 Please restart the server to register the custom commands!", new MessageUtils.Replaceable[0]));
        }
        return false;
    }

    @Override
    public String getUsage() {
        return "/serverlinksz reload";
    }

    @Override
    public boolean hasPermission(CommandSender sender) {
        return sender.hasPermission("serverlinksz.admin");
    }
}

