/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.serverlinksz.commands;

import com.zetaplugins.serverlinksz.ServerLinksZ;
import com.zetaplugins.serverlinksz.commands.CommandUtils;
import com.zetaplugins.serverlinksz.util.LinkManager;
import com.zetaplugins.serverlinksz.util.MessageUtils;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.TabCompleter;
import org.jetbrains.annotations.NotNull;

public class LinkCommand
implements CommandExecutor,
TabCompleter {
    private final ServerLinksZ plugin;

    public LinkCommand(ServerLinksZ plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, String[] args) {
        String linkID;
        List<String> linkCommands = List.of("discord", "website", "store", "teamspeak", "twitter", "youtube", "instagram", "facebook", "tiktok", "vote");
        String string = linkCommands.contains(command.getName()) | this.plugin.getLinkManager().getLinkKeys().contains(command.getName()) ? command.getName() : (linkID = args.length > 0 ? args[0] : null);
        if (linkID == null) {
            CommandUtils.throwUsageError(sender, "/" + command.getName() + " <id>");
            return false;
        }
        if (!this.plugin.getLinkManager().getLinkKeys().contains(linkID)) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "linkNotFound", "&cLink with id <#00BFFF>%id%&c not found!", new MessageUtils.Replaceable("%id%", linkID)));
            return false;
        }
        LinkManager.Link link = this.plugin.getLinkManager().getLink(linkID);
        if (link == null) {
            return false;
        }
        if (!link.allowCommand()) {
            sender.sendMessage(MessageUtils.getAndFormatMsg(false, "linkCcommandNotAllowed", "&cYou are not allowed to access this command via a link!", new MessageUtils.Replaceable[0]));
            return false;
        }
        sender.sendMessage(MessageUtils.getAndFormatMsg(false, "linkCommand", "&7-> <click:OPEN_URL:%url%><hover:show_text:'&7%url%'><u>%name%</u></hover></click> &r&7<-", new MessageUtils.Replaceable("%url%", link.url()), new MessageUtils.Replaceable("%name%", link.name())));
        return false;
    }

    public List<String> onTabComplete(@NotNull CommandSender sender, @NotNull Command command, @NotNull String alias, String[] args) {
        if (args.length == 1) {
            return this.plugin.getLinkManager().getLinkKeys(LinkManager.Link::allowCommand).stream().toList();
        }
        return null;
    }
}

