/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.serverlinksz;

import com.zetaplugins.serverlinksz.util.CommandManager;
import com.zetaplugins.serverlinksz.util.EventManager;
import com.zetaplugins.serverlinksz.util.LanguageManager;
import com.zetaplugins.serverlinksz.util.LinkManager;
import com.zetaplugins.serverlinksz.util.bStats.CustomCharts;
import com.zetaplugins.serverlinksz.util.bStats.Metrics;
import java.io.File;
import org.bukkit.plugin.java.JavaPlugin;

public final class ServerLinksZ
extends JavaPlugin {
    private CommandManager commandManager;
    private LanguageManager languageManager;
    private EventManager eventManager;
    private LinkManager linkManager;

    public void onEnable() {
        this.getConfig().options().copyDefaults(true);
        this.saveDefaultConfig();
        this.languageManager = new LanguageManager(this);
        this.linkManager = new LinkManager(this);
        this.linkManager.updateLinks();
        this.eventManager = new EventManager(this);
        this.eventManager.registerListeners();
        this.commandManager = new CommandManager(this);
        this.commandManager.registerCommands();
        this.initializeBStats();
        this.getLogger().info("ServerLinksZ has been enabled!");
    }

    public void onDisable() {
        this.getLogger().info("ServerLinksZ has been disabled!");
    }

    public static ServerLinksZ getInstance() {
        return (ServerLinksZ)JavaPlugin.getPlugin(ServerLinksZ.class);
    }

    public LanguageManager getLanguageManager() {
        return this.languageManager;
    }

    public CommandManager getCommandManager() {
        return this.commandManager;
    }

    public EventManager getEventManager() {
        return this.eventManager;
    }

    public LinkManager getLinkManager() {
        return this.linkManager;
    }

    private void initializeBStats() {
        int pluginId = 22795;
        Metrics metrics = new Metrics(this, 22795);
        metrics.addCustomChart(CustomCharts.getLanguageChart(this));
        metrics.addCustomChart(CustomCharts.getLinksChart(this));
    }

    public File getPluginFile() {
        return this.getFile();
    }
}

