/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.storage.repositories.warps;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.storage.connectionPool.ConnectionPool;
import com.zetaplugins.essentialz.storage.model.WarpData;
import com.zetaplugins.essentialz.storage.repositories.Repository;
import com.zetaplugins.essentialz.storage.repositories.warps.WarpsRepository;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;

public abstract class SQLWarpsRepository
extends Repository
implements WarpsRepository {
    public SQLWarpsRepository(EssentialZ plugin, ConnectionPool connectionPool) {
        super(plugin, connectionPool);
    }

    @Override
    public void initializeTable() {
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            try (Statement statement = connection.createStatement();){
                StringBuilder warpsTableSql = new StringBuilder();
                warpsTableSql.append("CREATE TABLE IF NOT EXISTS warps (").append("name TEXT PRIMARY KEY, ").append("world TEXT, ").append("x DOUBLE, ").append("y DOUBLE, ").append("z DOUBLE, ").append("yaw FLOAT, ").append("pitch FLOAT").append(");");
                statement.executeUpdate(warpsTableSql.toString());
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to create warps SQLite table:", e);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to create warps SQLite table:", e);
        }
    }

    /*
     * Exception decompiling
     */
    @Override
    public WarpData load(String warpName) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 6 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    @Override
    public void save(WarpData warpData) {
        String sql = this.getInserOrReplaceWarpStatement();
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                return;
            }
            try (PreparedStatement statement = connection.prepareStatement(sql);){
                statement.setString(1, warpData.getName());
                statement.setString(2, warpData.getWorld());
                statement.setDouble(3, warpData.getX());
                statement.setDouble(4, warpData.getY());
                statement.setDouble(5, warpData.getZ());
                statement.setFloat(6, warpData.getYaw());
                statement.setFloat(7, warpData.getPitch());
                statement.executeUpdate();
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to save warp to SQL database:", e);
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to save warp to SQL database:", e);
        }
    }

    protected abstract String getInserOrReplaceWarpStatement();

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public boolean delete(String warpName) {
        String sql = "DELETE FROM warps WHERE name = ?";
        try (Connection connection = this.getConnection();){
            boolean bl;
            block18: {
                if (connection == null) {
                    boolean bl2 = false;
                    return bl2;
                }
                PreparedStatement statement = connection.prepareStatement("DELETE FROM warps WHERE name = ?");
                try {
                    statement.setString(1, warpName);
                    int rowsAffected = statement.executeUpdate();
                    boolean bl2 = bl = rowsAffected > 0;
                    if (statement == null) break block18;
                }
                catch (Throwable throwable) {
                    try {
                        if (statement != null) {
                            try {
                                statement.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (SQLException e) {
                        this.getPlugin().getLogger().log(Level.SEVERE, "Failed to delete warp from SQL database:", e);
                        boolean bl4 = false;
                        return bl4;
                    }
                }
                statement.close();
            }
            return bl;
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to delete warp from SQL database:", e);
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public List<String> getAllWarpNames() {
        ArrayList<String> warpNames = new ArrayList<String>();
        String sql = "SELECT name FROM warps";
        try (Connection connection = this.getConnection();){
            if (connection == null) {
                ArrayList<String> arrayList = warpNames;
                return arrayList;
            }
            try (PreparedStatement statement = connection.prepareStatement("SELECT name FROM warps");){
                try (ResultSet resultSet = statement.executeQuery();){
                    while (resultSet.next()) {
                        warpNames.add(resultSet.getString("name"));
                    }
                    return warpNames;
                }
                catch (SQLException e) {
                    this.getPlugin().getLogger().log(Level.SEVERE, "Failed to retrieve warp names from SQL database:", e);
                    return warpNames;
                }
            }
            catch (SQLException e) {
                this.getPlugin().getLogger().log(Level.SEVERE, "Failed to retrieve warp names from SQL database:", e);
                return warpNames;
            }
        }
        catch (SQLException e) {
            this.getPlugin().getLogger().log(Level.SEVERE, "Failed to retrieve warp names from SQL database:", e);
        }
        return warpNames;
    }
}

