/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.storage;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.config.storage.StorageConfig;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.storage.connectionPool.MySQLConnectionPool;
import com.zetaplugins.essentialz.storage.repositories.ignores.IgnoresRepository;
import com.zetaplugins.essentialz.storage.repositories.ignores.SQLIgnoresRepository;
import com.zetaplugins.essentialz.storage.repositories.player.PlayerRepository;
import com.zetaplugins.essentialz.storage.repositories.player.SQLPlayerRepository;
import com.zetaplugins.essentialz.storage.repositories.warps.MySQLWarpsRepository;
import com.zetaplugins.essentialz.storage.repositories.warps.WarpsRepository;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.services.config.ConfigService;

public final class MySQLStorage
extends Storage {
    private final SQLPlayerRepository playerRepository;
    private final SQLIgnoresRepository ignoresRepository;
    private final MySQLWarpsRepository warpsRepository;
    @InjectManager
    private ConfigService configManager;

    public MySQLStorage(EssentialZ plugin, StorageConfig storageConfig) {
        super(plugin);
        MySQLConnectionPool connectionPool = new MySQLConnectionPool(storageConfig.getHost(), String.valueOf(storageConfig.getPort()), storageConfig.getDatabase(), storageConfig.getUsername(), storageConfig.getPassword());
        this.playerRepository = new SQLPlayerRepository(plugin, connectionPool);
        this.ignoresRepository = new SQLIgnoresRepository(plugin, connectionPool);
        this.warpsRepository = new MySQLWarpsRepository(plugin, connectionPool);
    }

    @Override
    public void initializeDatabase() {
        this.playerRepository.initializeTable();
        this.ignoresRepository.initializeTable();
        this.warpsRepository.initializeTable();
    }

    @Override
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    public IgnoresRepository getIgnoresRepository() {
        return this.ignoresRepository;
    }

    @Override
    public WarpsRepository getWarpsRepository() {
        return this.warpsRepository;
    }
}

