/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.updatechecker;

import com.zetaplugins.zetacore.services.updatechecker.SemanticVersion;
import com.zetaplugins.zetacore.services.updatechecker.UpdateChecker;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import org.bukkit.plugin.java.JavaPlugin;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class HangarUpdateChecker
extends UpdateChecker {
    private final String slugOrId;
    private final String ownerString;

    public HangarUpdateChecker(JavaPlugin plugin, String ownerString, String slugOrId) {
        super(plugin);
        this.ownerString = ownerString;
        this.slugOrId = slugOrId;
    }

    @Override
    public void checkForUpdates(boolean logMessage) {
        String latestVersion = this.fetchLatestVersion();
        if (latestVersion == null) {
            return;
        }
        String currentVersion = this.getPlugin().getDescription().getVersion();
        if (this.hangarVersionIsNewer(latestVersion, currentVersion)) {
            this.setNewVersionAvailable(true);
            this.setLatestVersion(latestVersion);
            this.getLogger().info(this.getNewVersionConsoleMessage(latestVersion, currentVersion, this.getVersionUrl(latestVersion)));
        } else {
            this.setNewVersionAvailable(false);
        }
    }

    @Override
    public String getLatestVersionUrl() {
        return this.getVersionUrl(this.getLatestVersion());
    }

    public String getVersionUrl(String version) {
        return "https://hangar.papermc.io/" + this.ownerString + "/" + this.slugOrId + "/versions/" + version;
    }

    private boolean hangarVersionIsNewer(String latestVersion, String currentVersion) {
        try {
            SemanticVersion latest = new SemanticVersion(latestVersion);
            SemanticVersion current = new SemanticVersion(currentVersion);
            return latest.isGreaterThan(current);
        }
        catch (IllegalArgumentException e) {
            return !latestVersion.trim().equals(currentVersion.trim());
        }
    }

    private String fetchLatestVersion() {
        String mcVersion = this.getPlugin().getServer().getMinecraftVersion();
        String encodedGameVersion = URLEncoder.encode(mcVersion, StandardCharsets.UTF_8);
        String versionsUrl = "https://hangar.papermc.io/api/v1/projects/" + this.slugOrId + "/versions?platform=PAPER&platformVersion=" + encodedGameVersion;
        JSONObject json = this.fetchJsonObjectFromUrl(versionsUrl);
        if (json == null) {
            return null;
        }
        JSONArray results = (JSONArray)json.get((Object)"result");
        if (results == null || results.isEmpty()) {
            return null;
        }
        JSONObject latest = (JSONObject)results.get(0);
        return (String)latest.get((Object)"name");
    }

    private JSONObject fetchJsonObjectFromUrl(String urlString) {
        try {
            HttpURLConnection connection = this.createHttpConnection(urlString);
            if (connection.getResponseCode() == 200) {
                String response = this.readResponse(connection);
                return (JSONObject)new JSONParser().parse(response);
            }
            this.getLogger().warning("Failed to retrieve data from " + urlString + " Response code: " + connection.getResponseCode());
        }
        catch (IOException | ParseException e) {
            this.getLogger().warning("Error fetching data: " + e.getMessage());
        }
        return null;
    }

    private HttpURLConnection createHttpConnection(String urlString) throws IOException {
        URL url = new URL(urlString);
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        connection.setRequestMethod("GET");
        connection.setRequestProperty("Accept", "application/json");
        return connection;
    }

    private String readResponse(HttpURLConnection connection) throws IOException {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));){
            String line;
            StringBuilder response = new StringBuilder();
            while ((line = reader.readLine()) != null) {
                response.append(line);
            }
            String string = response.toString();
            return string;
        }
    }
}

