/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.util;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.config.main.MainConfig;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.annotations.Manager;
import com.zetaplugins.zetacore.annotations.PostManagerConstruct;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.io.File;
import java.util.List;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.java.JavaPlugin;

@Manager
public class LanguageManager {
    private final JavaPlugin plugin;
    public static final List<String> defaultLangs = List.of("en-US");
    private FileConfiguration langConfig;
    @InjectManager
    private ConfigService configService;

    public LanguageManager(EssentialZ plugin) {
        this.plugin = plugin;
    }

    @PostManagerConstruct
    public void init() {
        this.loadLanguageConfig();
    }

    public void reload() {
        this.loadLanguageConfig();
    }

    private void loadLanguageConfig() {
        File languageDirectory = new File(this.plugin.getDataFolder(), "lang/");
        if (!languageDirectory.exists() || !languageDirectory.isDirectory()) {
            languageDirectory.mkdir();
        }
        for (String langString : defaultLangs) {
            File langFile = new File("lang/", langString + ".yml");
            if (new File(languageDirectory, langString + ".yml").exists()) continue;
            this.plugin.getLogger().info("Saving file " + langFile.getPath());
            this.plugin.saveResource(langFile.getPath(), false);
        }
        MainConfig mainConfig = this.configService.getConfig(MainConfig.class);
        String langOption = mainConfig.getLanguage() != null ? mainConfig.getLanguage() : "en-US";
        File selectedLangFile = new File(languageDirectory, langOption + ".yml");
        if (!selectedLangFile.exists()) {
            selectedLangFile = new File(languageDirectory, "en-US.yml");
            this.plugin.getLogger().warning("Language file " + langOption + ".yml (" + selectedLangFile.getPath() + ") not found! Using fallback en-US.yml.");
        }
        this.plugin.getLogger().info("Using language file: " + selectedLangFile.getPath());
        this.langConfig = YamlConfiguration.loadConfiguration((File)selectedLangFile);
    }

    public String getString(String key) {
        return this.langConfig.getString(key);
    }

    public String getString(String key, String fallback) {
        return this.langConfig.getString(key) != null ? this.langConfig.getString(key) : fallback;
    }
}

