/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.features.economy.manager;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.config.economy.CurrencyFormatConfigSection;
import com.zetaplugins.essentialz.config.economy.EconomyConfig;
import com.zetaplugins.essentialz.features.economy.EconomyUtil;
import com.zetaplugins.essentialz.features.economy.manager.EconomyManager;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.storage.model.PlayerData;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.annotations.PostManagerConstruct;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;

public class BuiltinEconomyManager
implements EconomyManager {
    private CurrencyFormatConfigSection currencyConfig;
    @InjectManager
    private ConfigService configService;
    @InjectManager
    private Storage storage;
    @InjectManager
    private EssentialZ plugin;

    @PostManagerConstruct
    public void init() {
        this.currencyConfig = this.configService.getConfig(EconomyConfig.class).getCurrencyFormat();
    }

    @Override
    public double getBalance(OfflinePlayer player) {
        PlayerData playerData = this.storage.getPlayerRepository().load(player.getUniqueId());
        if (playerData == null) {
            return 0.0;
        }
        return playerData.getBalance();
    }

    @Override
    public void deposit(OfflinePlayer player, double amount) {
        PlayerData playerData;
        if (amount < 0.0) {
            amount = 0.0;
        }
        if ((playerData = this.storage.getPlayerRepository().load(player.getUniqueId())) == null) {
            playerData = new PlayerData(player.getUniqueId());
        }
        double currentBalance = playerData.getBalance();
        playerData.setBalance(currentBalance + amount);
        this.storage.getPlayerRepository().save(playerData);
    }

    @Override
    public boolean withdraw(OfflinePlayer player, double amount) {
        double currentBalance;
        PlayerData playerData;
        if (amount < 0.0) {
            amount = 0.0;
        }
        if ((playerData = this.storage.getPlayerRepository().load(player.getUniqueId())) == null) {
            playerData = new PlayerData(player.getUniqueId());
        }
        if ((currentBalance = playerData.getBalance()) < amount) {
            return false;
        }
        playerData.setBalance(currentBalance - amount);
        this.storage.getPlayerRepository().save(playerData);
        return true;
    }

    @Override
    public void setBalance(OfflinePlayer player, double amount) {
        PlayerData playerData;
        if (amount < 0.0) {
            amount = 0.0;
        }
        if ((playerData = this.storage.getPlayerRepository().load(player.getUniqueId())) == null) {
            playerData = new PlayerData(player.getUniqueId());
        }
        playerData.setBalance(amount);
        this.storage.getPlayerRepository().save(playerData);
    }

    @Override
    public String format(double amount) {
        return EconomyUtil.formatCurrency(amount, this.currencyConfig);
    }

    @Override
    public Map<UUID, Double> getTopBalances(int topN) {
        return this.storage.getPlayerRepository().getTopBalances(topN);
    }
}

