/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.items;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.config.main.MainConfig;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@AutoRegisterCommand(commands={"itemname"}, description="Set the name of the item you are holding.", usage="/itemname <name>", permission="essentialz.itemname")
public class ItemNameCommand
extends EszCommand {
    @InjectManager
    private ConfigService configService;

    public ItemNameCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandSenderMustBePlayerException {
        if (!(sender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)sender;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.MUST_HOLD_AN_ITEM, new MessageManager.Replaceable[0]));
            return false;
        }
        StringBuilder newName = new StringBuilder();
        for (String arg : args) {
            newName.append(arg);
            if (arg.equals(args.getArg(args.size() - 1))) continue;
            newName.append(" ");
        }
        int maxLength = this.configService.getConfig(MainConfig.class).getMaxItemNameLength();
        if (newName.length() > maxLength && maxLength != -1) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.ITEM_NAME_TOO_LONG, new MessageManager.Replaceable<String>("{max}", String.valueOf(maxLength))));
            return false;
        }
        ItemMeta newMeta = item.getItemMeta();
        newMeta.displayName(this.getMessageManager().formatMsg(newName.toString(), new MessageManager.Replaceable[0]));
        item.setItemMeta(newMeta);
        sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.ITEM_NAME_SET, new MessageManager.Replaceable<String>("{name}", newName.toString())));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        return List.of();
    }
}

