/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.PluginMessage;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBeOrSpecifyPlayerException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"feed"}, description="Feed a player to full hunger", usage="/feed [player]", permission="essentialz.feed")
public class FeedCommand
extends EszCommand {
    public FeedCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandException, CommandSenderMustBeOrSpecifyPlayerException {
        boolean isSelfFeed;
        Player targetPlayer = args.getPlayer(0, sender instanceof Player ? (Player)sender : null, (JavaPlugin)this.getPlugin());
        if (targetPlayer == null) {
            throw new CommandSenderMustBeOrSpecifyPlayerException();
        }
        boolean bl = isSelfFeed = sender instanceof Player && ((Player)sender).getUniqueId().equals(targetPlayer.getUniqueId());
        if (!isSelfFeed && !Permission.HEAL_OTHERS.has((Permissible)sender)) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.NO_PERMISSION_FEED_OTHERS, new MessageManager.Replaceable[0]));
            return false;
        }
        targetPlayer.setFoodLevel(20);
        targetPlayer.setSaturation(20.0f);
        if (isSelfFeed) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.FEED_SELF, new MessageManager.Replaceable[0]));
        } else {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(PluginMessage.FEED_OTHER, new MessageManager.Replaceable<String>("{player}", targetPlayer.getName())));
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0 && Permission.FEED_OTHERS.has((Permissible)sender)) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

