/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.storage;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.storage.connectionPool.SQLiteConnectionPool;
import com.zetaplugins.essentialz.storage.repositories.ignores.IgnoresRepository;
import com.zetaplugins.essentialz.storage.repositories.ignores.SQLIgnoresRepository;
import com.zetaplugins.essentialz.storage.repositories.player.PlayerRepository;
import com.zetaplugins.essentialz.storage.repositories.player.SQLPlayerRepository;
import com.zetaplugins.essentialz.storage.repositories.warps.SQLiteWarpsRepository;
import com.zetaplugins.essentialz.storage.repositories.warps.WarpsRepository;

public final class SQLiteStorage
extends Storage {
    private final SQLPlayerRepository playerRepository;
    private final SQLIgnoresRepository ignoresRepository;
    private final SQLiteWarpsRepository warpsRepository;

    public SQLiteStorage(EssentialZ plugin) {
        super(plugin);
        SQLiteConnectionPool connectionPool = new SQLiteConnectionPool(plugin.getDataFolder().getPath() + "/userData.db");
        this.playerRepository = new SQLPlayerRepository(plugin, connectionPool);
        this.ignoresRepository = new SQLIgnoresRepository(plugin, connectionPool);
        this.warpsRepository = new SQLiteWarpsRepository(plugin, connectionPool);
    }

    @Override
    public void initializeDatabase() {
        this.playerRepository.initializeTable();
        this.ignoresRepository.initializeTable();
        this.warpsRepository.initializeTable();
    }

    @Override
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    public IgnoresRepository getIgnoresRepository() {
        return this.ignoresRepository;
    }

    @Override
    public WarpsRepository getWarpsRepository() {
        return this.warpsRepository;
    }
}

