/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.items;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.MessageStyle;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.kyori.adventure.text.Component;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.ItemMeta;

@AutoRegisterCommand(commands={"itemlore"}, description="Manage the lore of the item in your hand", usage="/itemlore <add|set|remove|insert> <line> [lore]", permission="essentialz.itemlore", aliases={"lore"})
public class ItemLoreCommand
extends EszCommand {
    public ItemLoreCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandSenderMustBePlayerException, CommandUsageException {
        if (!(sender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)sender;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ERROR, "mustHoldAnItem", "{ac}You must be holding an item.", new MessageManager.Replaceable[0]));
            return false;
        }
        if (args.size() < 1) {
            throw new CommandUsageException("/itemlore <add|set|remove> <line> [lore]");
        }
        String action = args.getArg(0);
        if (!List.of("add", "set", "remove", "insert").contains(action)) {
            throw new CommandUsageException("/itemlore <add|set|remove> <line> [lore]");
        }
        switch (action) {
            case "add": {
                if (args.size() < 2) {
                    throw new CommandUsageException("/itemlore add <lore>");
                }
                String lore = this.getLoreFromArgs(args, 1);
                return this.handleAddLore(player, item, lore);
            }
            case "set": {
                if (args.size() < 3) {
                    throw new CommandUsageException("/itemlore set <line> <lore>");
                }
                try {
                    int line = Integer.parseInt(args.getArg(1)) - 1;
                    String lore = this.getLoreFromArgs(args, 2);
                    return this.handleSetLore(player, item, line, lore);
                }
                catch (NumberFormatException e) {
                    throw new CommandUsageException("/itemlore set <line> <lore>");
                }
            }
            case "remove": {
                if (args.size() < 2) {
                    throw new CommandUsageException("/itemlore remove <line>");
                }
                try {
                    int line = Integer.parseInt(args.getArg(1)) - 1;
                    return this.handleRemoveLore(player, item, line);
                }
                catch (NumberFormatException e) {
                    throw new CommandUsageException("/itemlore remove <line>");
                }
            }
            case "insert": {
                if (args.size() < 3) {
                    throw new CommandUsageException("/itemlore insert <line> <lore>");
                }
                try {
                    int line = Integer.parseInt(args.getArg(1)) - 1;
                    String lore = this.getLoreFromArgs(args, 2);
                    return this.handleInsertLore(player, item, line, lore);
                }
                catch (NumberFormatException e) {
                    throw new CommandUsageException("/itemlore insert <line> <lore>");
                }
            }
        }
        return false;
    }

    private boolean handleAddLore(Player player, ItemStack item, String lore) {
        ArrayList<Component> currentLore = item.getItemMeta().lore();
        if (currentLore == null) {
            currentLore = new ArrayList<Component>();
        }
        int maxLoreLines = ((EssentialZ)((Object)this.getPlugin())).getConfig().getInt("maxLoreLines");
        if (currentLore.size() >= maxLoreLines || currentLore.size() >= 128) {
            player.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ERROR, "loreTooLong", "{ac}The lore is too long! The maximum length is {max} lines.", new MessageManager.Replaceable<String>("{max}", String.valueOf(maxLoreLines))));
            return false;
        }
        currentLore.add(this.getMessageManager().formatMsg(lore, new MessageManager.Replaceable[0]));
        this.setItemLore(item, currentLore);
        player.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ITEMS, "loreAdded", "&7Added '{lore}&r&7' to the lore.", new MessageManager.Replaceable<String>("{lore}", lore)));
        return true;
    }

    private boolean handleSetLore(Player player, ItemStack item, int line, String lore) {
        List currentLore = item.getItemMeta().lore();
        if (currentLore == null) {
            this.sendLoreLineDoesNotExistMessage(player);
            return false;
        }
        if (line < 0 || line >= currentLore.size()) {
            this.sendLoreLineDoesNotExistMessage(player);
            return false;
        }
        currentLore.set(line, this.getMessageManager().formatMsg(lore, new MessageManager.Replaceable[0]));
        this.setItemLore(item, currentLore);
        player.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ITEMS, "loreSet", "&7Set lore line {ac}{line}&7 to '{lore}&r&7'.", new MessageManager.Replaceable<String>("{line}", String.valueOf(line + 1)), new MessageManager.Replaceable<String>("{lore}", lore)));
        return true;
    }

    private boolean handleRemoveLore(Player player, ItemStack item, int line) {
        List currentLore = item.getItemMeta().lore();
        if (currentLore == null) {
            this.sendLoreLineDoesNotExistMessage(player);
            return false;
        }
        if (line < 0 || line >= currentLore.size()) {
            this.sendLoreLineDoesNotExistMessage(player);
            return false;
        }
        currentLore.remove(line);
        this.setItemLore(item, currentLore);
        player.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ITEMS, "loreRemoved", "&7Removed lore line {ac}{line}&7.", new MessageManager.Replaceable<String>("{line}", String.valueOf(line + 1))));
        return true;
    }

    private boolean handleInsertLore(Player player, ItemStack item, int line, String lore) {
        List currentLore = item.getItemMeta().lore();
        if (currentLore == null) {
            this.sendLoreLineDoesNotExistMessage(player);
            return false;
        }
        if (line < 0 || line >= currentLore.size()) {
            this.sendLoreLineDoesNotExistMessage(player);
            return false;
        }
        int maxLoreLines = ((EssentialZ)((Object)this.getPlugin())).getConfig().getInt("maxLoreLines");
        if (currentLore.size() >= maxLoreLines || currentLore.size() >= 128) {
            player.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ERROR, "loreTooLong", "{ac}The lore is too long! The maximum length is {max} lines.", new MessageManager.Replaceable<String>("{max}", String.valueOf(maxLoreLines))));
            return false;
        }
        currentLore.add(line, this.getMessageManager().formatMsg(lore, new MessageManager.Replaceable[0]));
        this.setItemLore(item, currentLore);
        player.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ITEMS, "loreInserted", "&7Inserted '{lore}&r&7' at line {ac}{line}&7.", new MessageManager.Replaceable<String>("{line}", String.valueOf(line + 1)), new MessageManager.Replaceable<String>("{lore}", lore)));
        return true;
    }

    private String getLoreFromArgs(ArgumentList args, int startIndex) {
        StringBuilder lore = new StringBuilder();
        for (int i = startIndex; i < args.size(); ++i) {
            lore.append(args.getArg(i));
            if (i == args.size() - 1) continue;
            lore.append(" ");
        }
        return lore.toString();
    }

    private void setItemLore(ItemStack item, List<Component> lore) {
        ItemMeta meta = item.getItemMeta();
        meta.lore(lore);
        item.setItemMeta(meta);
    }

    private void sendLoreLineDoesNotExistMessage(Player player) {
        player.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ERROR, "loreLineDoesNotExist", "{ac}This lore line does not exist!", new MessageManager.Replaceable[0]));
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return this.getDisplayOptions(List.of("add", "set", "remove", "insert"), args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 1 && List.of("set", "remove", "insert").contains(args.getArg(0))) {
            return this.getDisplayOptions(this.getItemLoreLines(sender).stream().map(Object::toString).collect(Collectors.toList()), args.getCurrentArg());
        }
        return List.of();
    }

    private List<Integer> getItemLoreLines(CommandSender sender) {
        if (!(sender instanceof Player)) {
            return List.of();
        }
        Player player = (Player)sender;
        ItemStack item = player.getInventory().getItemInMainHand();
        if (item.getType() == Material.AIR) {
            return List.of();
        }
        List lore = item.getItemMeta().lore();
        if (lore == null) {
            return List.of();
        }
        ArrayList<Integer> lines = new ArrayList<Integer>();
        for (int i = 0; i < lore.size(); ++i) {
            lines.add(i + 1);
        }
        return lines;
    }
}

