/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.communication;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.MessageStyle;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.Collection;
import java.util.List;
import net.kyori.adventure.text.serializer.plain.PlainTextComponentSerializer;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@AutoRegisterCommand(commands={"whois"}, description="Get information about a player.", usage="/whois <player>", permission="essentialz.whois")
public class WhoisCommand
extends EszCommand {
    public WhoisCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandUsageException {
        String targetName = args.getArg(0);
        if (targetName == null || targetName.isEmpty()) {
            throw new CommandUsageException("/whois <player>");
        }
        boolean found = false;
        for (Player player : Bukkit.getOnlinePlayers()) {
            String realName = player.getName();
            String displayName = PlainTextComponentSerializer.plainText().serialize(player.displayName());
            if (!realName.equalsIgnoreCase(targetName) && !displayName.equalsIgnoreCase(targetName)) continue;
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.NONE, "whoisInfo", "&8\u250c\u2500 <#81C784>Whois Info&r&8 \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n&8\u2502 &7Nickname: <#4CAF50>{displayname}\n&8\u2502 &7Real Name: <#E9D502>{realname}\n&8\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n", new MessageManager.Replaceable<String>("{displayname}", displayName), new MessageManager.Replaceable<String>("{realname}", realName)));
            found = true;
        }
        if (!found) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageStyle.ERROR, "noOneWithNameFound", "{ac}Could not find online player with name or nickname '{name}'!", new MessageManager.Replaceable<String>("{name}", targetName)));
            return false;
        }
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return Bukkit.getOnlinePlayers().stream().map(player -> {
                String realName = player.getName();
                String displayName = PlainTextComponentSerializer.plainText().serialize(player.displayName());
                return List.of(realName, displayName);
            }).flatMap(Collection::stream).filter(name -> name.toLowerCase().startsWith(args.getArg(0).toLowerCase())).toList();
        }
        return List.of();
    }
}

