/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.util;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.LanguageManager;
import com.zetaplugins.zetacore.annotations.InjectManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.TextComponent;
import net.kyori.adventure.text.minimessage.MiniMessage;
import net.kyori.adventure.text.minimessage.tag.Tag;
import net.kyori.adventure.text.minimessage.tag.resolver.TagResolver;

public class MessageManager {
    private final EssentialZ plugin;
    private final Map<String, String> colorMap;
    @InjectManager
    private LanguageManager languageManager;

    public MessageManager(EssentialZ plugin) {
        this.plugin = plugin;
        this.colorMap = new HashMap<String, String>();
        this.colorMap.put("&0", "<black>");
        this.colorMap.put("&1", "<dark_blue>");
        this.colorMap.put("&2", "<dark_green>");
        this.colorMap.put("&3", "<dark_aqua>");
        this.colorMap.put("&4", "<dark_red>");
        this.colorMap.put("&5", "<dark_purple>");
        this.colorMap.put("&6", "<gold>");
        this.colorMap.put("&7", "<gray>");
        this.colorMap.put("&8", "<dark_gray>");
        this.colorMap.put("&9", "<blue>");
        this.colorMap.put("&a", "<green>");
        this.colorMap.put("&b", "<aqua>");
        this.colorMap.put("&c", "<red>");
        this.colorMap.put("&d", "<light_purple>");
        this.colorMap.put("&e", "<yellow>");
        this.colorMap.put("&f", "<white>");
        this.colorMap.put("&k", "<obfuscated>");
        this.colorMap.put("&l", "<bold>");
        this.colorMap.put("&m", "<strikethrough>");
        this.colorMap.put("&n", "<underline>");
        this.colorMap.put("&o", "<italic>");
        this.colorMap.put("&r", "<reset>");
    }

    public Component formatMsg(String msg, Replaceable<?> ... replaceables) {
        MiniMessage mm = MiniMessage.miniMessage();
        msg = this.replaceColorCodes(msg);
        ResolverResult result = this.buildResolvers(mm, msg, Style.NONE, replaceables);
        return mm.deserialize("<!i>" + result.msg(), result.resolvers());
    }

    public Component getAndFormatMsg(Style style, String path, String fallback, Replaceable<?> ... replaceables) {
        return this.getAndFormatMsg(style, path, fallback, true, replaceables);
    }

    public Component getAndFormatMsg(Style style, String path, String fallback, boolean addPrefix, Replaceable<?> ... replaceables) {
        if (path.startsWith("messages.")) {
            path = path.substring("messages.".length());
        }
        MiniMessage mm = MiniMessage.miniMessage();
        Object msg = this.languageManager.getString(path, fallback);
        if (addPrefix) {
            msg = style.getPrefix(this.plugin) + (String)msg;
        }
        msg = ((String)msg).replace("{prefix}", style.getPrefix(this.plugin));
        msg = this.replaceColorCodes((String)msg, style);
        ResolverResult result = this.buildResolvers(mm, (String)msg, style, replaceables);
        return mm.deserialize("<!i>" + result.msg(), result.resolvers());
    }

    private ResolverResult buildResolvers(MiniMessage mm, String msg, Style valueStyle, Replaceable<?> ... replaceables) {
        ArrayList<TagResolver.Single> resolvers = new ArrayList<TagResolver.Single>();
        Style replacementStyle = valueStyle == null ? Style.NONE : valueStyle;
        for (Replaceable<?> r : replaceables) {
            String rawName = r.placeholder().replaceAll("^\\{?|\\}?$", "");
            String tagName = rawName.toLowerCase(Locale.ROOT).replaceAll("[^a-z0-9_-]", "_");
            String tagToken = "<" + tagName + ">";
            msg = msg.replace(r.placeholder(), tagToken);
            String valueStr = Objects.toString(r.value());
            TextComponent replacementComponent = r.deserialize() ? mm.deserialize((Object)this.replaceColorCodes(valueStr, replacementStyle)) : Component.text((String)valueStr);
            resolvers.add(TagResolver.resolver((String)tagName, (Tag)Tag.inserting((Component)replacementComponent)));
        }
        return new ResolverResult(msg, (TagResolver[])resolvers.toArray(TagResolver[]::new));
    }

    private String replaceColorCodes(String msg) {
        return this.replaceColorCodes(msg, Style.NONE);
    }

    private String replaceColorCodes(String msg, Style style) {
        msg = msg.replace("{ac}", "<" + style.getAccentColor(this.plugin) + ">");
        for (Style currentStyle : Style.values()) {
            String styleAccentColor = currentStyle.getAccentColor(this.plugin);
            msg = msg.replace("{ac_" + currentStyle.getId() + "}", "<" + styleAccentColor + ">");
        }
        for (Map.Entry entry : this.colorMap.entrySet()) {
            msg = msg.replace((CharSequence)entry.getKey(), (CharSequence)entry.getValue());
        }
        return msg;
    }

    public static enum Style {
        NONE("none"),
        DEFAULT("default"),
        ERROR("error"),
        WARNING("warning"),
        SUCCESS("success"),
        MOVEMENT("movement"),
        COMBAT("combat"),
        MODERATION("moderation"),
        ITEMS("items"),
        STATS("stats"),
        COMMUNICATION("communication"),
        TEAMCHAT("teamchat"),
        WORLDCONTROL("worldcontrol"),
        ECONOMY("economy");

        public final String id;

        private Style(String id) {
            this.id = id;
        }

        public String getId() {
            return this.id;
        }

        public String getAccentColor(EssentialZ plugin) {
            if (Objects.equals(this.getId(), "none")) {
                return "#ba7cf8";
            }
            String accentColor = plugin.getConfig().getString("styles." + this.getId() + ".accentColor");
            return accentColor == null ? "#ba7cf8" : accentColor;
        }

        public String getPrefix(EssentialZ plugin) {
            if (Objects.equals(this.getId(), "none")) {
                return "";
            }
            String prefix = plugin.getConfig().getString("styles." + this.getId() + ".prefix");
            return prefix == null ? "&8[<gradient:#ba7cf8:#ba7cf8>EssentialZ&8]" : prefix;
        }

        public static Style of(String id) {
            for (Style style : Style.values()) {
                if (!style.id.equals(id)) continue;
                return style;
            }
            return null;
        }
    }

    public record Replaceable<T>(String placeholder, T value, boolean deserialize) {
        public Replaceable(String placeholder, T value) {
            this(placeholder, value, false);
        }
    }

    private record ResolverResult(String msg, TagResolver[] resolvers) {
    }
}

