/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.storage;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.storage.connectionPool.MySQLConnectionPool;
import com.zetaplugins.essentialz.storage.repositories.ignores.IgnoresRepository;
import com.zetaplugins.essentialz.storage.repositories.ignores.SQLIgnoresRepository;
import com.zetaplugins.essentialz.storage.repositories.player.PlayerRepository;
import com.zetaplugins.essentialz.storage.repositories.player.SQLPlayerRepository;
import com.zetaplugins.essentialz.storage.repositories.warps.MySQLWarpsRepository;
import com.zetaplugins.essentialz.storage.repositories.warps.WarpsRepository;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.services.config.ConfigService;
import org.bukkit.configuration.file.FileConfiguration;

public final class MySQLStorage
extends Storage {
    private final SQLPlayerRepository playerRepository;
    private final SQLIgnoresRepository ignoresRepository;
    private final MySQLWarpsRepository warpsRepository;
    @InjectManager
    private ConfigService configManager;

    public MySQLStorage(EssentialZ plugin, FileConfiguration storageConfig) {
        super(plugin);
        String HOST = storageConfig.getString("host");
        String PORT = storageConfig.getString("port");
        String DATABASE = storageConfig.getString("database");
        String USERNAME = storageConfig.getString("username");
        String PASSWORD = storageConfig.getString("password");
        MySQLConnectionPool connectionPool = new MySQLConnectionPool(HOST, PORT, DATABASE, USERNAME, PASSWORD);
        this.playerRepository = new SQLPlayerRepository(plugin, connectionPool);
        this.ignoresRepository = new SQLIgnoresRepository(plugin, connectionPool);
        this.warpsRepository = new MySQLWarpsRepository(plugin, connectionPool);
    }

    @Override
    public void initializeDatabase() {
        this.playerRepository.initializeTable();
        this.ignoresRepository.initializeTable();
        this.warpsRepository.initializeTable();
    }

    @Override
    public PlayerRepository getPlayerRepository() {
        return this.playerRepository;
    }

    @Override
    public IgnoresRepository getIgnoresRepository() {
        return this.ignoresRepository;
    }

    @Override
    public WarpsRepository getWarpsRepository() {
        return this.warpsRepository;
    }
}

