/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.moderation;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.GodModeManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandPermissionException;
import java.util.List;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"godmode"}, description="Toggles god mode for yourself or another player.", usage="/godmode [player]", aliases={"god"})
public class GodModeCommand
extends EszCommand {
    @InjectManager
    private GodModeManager godModeManager;

    public GodModeCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandPermissionException {
        Player player;
        Player targetPlayer = args.getPlayer(0, (JavaPlugin)this.getPlugin());
        if (!(targetPlayer == null || sender instanceof Player && (player = (Player)sender).getUniqueId().equals(targetPlayer.getUniqueId()))) {
            if (!Permission.GODMODE_OTHERS.has((Permissible)sender)) {
                throw new CommandPermissionException(Permission.GODMODE_OTHERS.getNode());
            }
            boolean isInGodMode = this.godModeManager.isInGodMode((OfflinePlayer)targetPlayer);
            this.godModeManager.setGodMode((OfflinePlayer)targetPlayer, !isInGodMode);
            this.sendConfirmMessage(targetPlayer, !isInGodMode);
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.MODERATION, "godModeToggledOther", "&7God mode for {ac}{player}&7 is now {ac}{status}&7.", new MessageManager.Replaceable<String>("{player}", targetPlayer.getName()), new MessageManager.Replaceable<String>("{status}", !isInGodMode ? "enabled" : "disabled")));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "specifyPlayerOrBePlayer", "{ac}You must specify a player or be a player to use this command.", new MessageManager.Replaceable[0]));
            return false;
        }
        player = (Player)sender;
        boolean isInGodMode = this.godModeManager.isInGodMode((OfflinePlayer)player);
        this.godModeManager.setGodMode((OfflinePlayer)player, !isInGodMode);
        this.sendConfirmMessage(player, !isInGodMode);
        return true;
    }

    public void sendConfirmMessage(Player player, boolean isInGodMode) {
        player.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.MODERATION, "godModeToggled", "&7God mode is now {ac}{status}&7.", new MessageManager.Replaceable<String>("{status}", isInGodMode ? "enabled" : "disabled")));
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0 && Permission.GODMODE_OTHERS.has((Permissible)sender)) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

