/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.communication;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.EszConfig;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.util.List;
import net.kyori.adventure.text.Component;
import org.bukkit.Bukkit;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;

@AutoRegisterCommand(commands={"broadcast"}, description="Broadcast a message to the server", permission="essentialz.broadcast", aliases={"bc", "bcast"})
public class Broadcast
extends EszCommand {
    @InjectManager
    private ConfigService configManager;

    public Broadcast(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandUsageException {
        if (args.size() < 1) {
            throw new CommandUsageException("/" + command.getName() + " <message>");
        }
        String message = args.getJoinedString(0);
        String broadCastFormat = this.configManager.getConfig(EszConfig.CHAT).getString("broadcastFormat");
        if (broadCastFormat == null) {
            broadCastFormat = "&8[<#F06292>Broadcast&8] &7{message}";
        }
        String formattedMessage = broadCastFormat.replace("{message}", message);
        Bukkit.broadcast((Component)this.getMessageManager().formatMsg(formattedMessage, new MessageManager.Replaceable[0]));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        return List.of();
    }
}

