/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.RulesManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandPermissionException;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.util.ArrayList;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.permissions.Permissible;

@AutoRegisterCommand(commands={"essentialz"}, description="Main command for the EssentialZ plugin.", usage="/essentialz", aliases={"esz"})
public class MainCommand
extends EszCommand {
    @InjectManager
    private MessageManager messageManager;
    @InjectManager
    private ConfigService configService;
    @InjectManager
    private RulesManager rulesManager;

    public MainCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String s, ArgumentList args) throws CommandException {
        String subcommand;
        switch (subcommand = args.getString(0, "about").toLowerCase()) {
            case "about": {
                sender.sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.DEFAULT, "aboutMessage", "\n{ac}<b><grey>></grey> EssentialZ</b> <grey>v%version%</grey>\n\n{ac} <u><click:open_url:'https://docs.zetaplugins.com/essentialz/'>Documentation</click></u>  {ac}<u><click:open_url:'https://strassburger.org/discord'>Support Discord</click></u>\n", false, new MessageManager.Replaceable<String>("%version%", ((EssentialZ)((Object)this.getPlugin())).getDescription().getVersion())));
                return true;
            }
            case "reload": {
                if (!Permission.RELOAD.has((Permissible)sender)) {
                    throw new CommandPermissionException(Permission.RELOAD.getNode());
                }
                ((EssentialZ)((Object)this.getPlugin())).reloadConfig();
                this.configService.clearCache();
                this.rulesManager.reload();
                sender.sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.SUCCESS, "reloaded", "&7EssentialZ has been successfully reloaded!", new MessageManager.Replaceable[0]));
                return true;
            }
        }
        throw new CommandException("Unknown subcommand. Use /essentialz help for a list of commands.");
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            ArrayList<String> options = new ArrayList<String>(List.of("about"));
            if (Permission.RELOAD.has((Permissible)sender)) {
                options.add("reload");
            }
            return options;
        }
        return List.of();
    }
}

