/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.util.commands;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.CommandPlayerNotFoundException;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.PluginCommand;
import com.zetaplugins.zetacore.commands.exceptions.CommandPermissionException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBeOrSpecifyPlayerException;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;

public abstract class EszCommand
extends PluginCommand<EssentialZ> {
    @InjectManager
    private MessageManager messageManager;

    public EszCommand(EssentialZ plugin) {
        super(plugin);
        this.registerExceptionHandler(CommandUsageException.class, (ctx, e) -> {
            ctx.getSender().sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ERROR, "usageError", "{ac}Usage: {usage}", new MessageManager.Replaceable<String>("{usage}", e.getUsage())));
            return false;
        });
        this.registerExceptionHandler(CommandPermissionException.class, (ctx, e) -> {
            ctx.getSender().sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ERROR, "noPermsError", "{ac}You do not have permission to do this!", new MessageManager.Replaceable[0]));
            return false;
        });
        this.registerExceptionHandler(CommandSenderMustBePlayerException.class, (ctx, e) -> {
            ctx.getSender().sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ERROR, "playerOnly", "{ac}You must be a player to use this command.", new MessageManager.Replaceable[0]));
            return false;
        });
        this.registerExceptionHandler(CommandSenderMustBeOrSpecifyPlayerException.class, (ctx, e) -> {
            ctx.getSender().sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ERROR, "specifyPlayerOrBePlayer", "{ac}You must specify a player or be a player to use this command.", new MessageManager.Replaceable[0]));
            return false;
        });
        this.registerExceptionHandler(CommandPlayerNotFoundException.class, (ctx, e) -> {
            ctx.getSender().sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ERROR, "playerNotFound", "{ac}Player not found.", new MessageManager.Replaceable[0]));
            return false;
        });
    }

    protected MessageManager getMessageManager() {
        return this.messageManager;
    }
}

