/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.features;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.zetacore.annotations.InjectPlugin;
import com.zetaplugins.zetacore.annotations.PostManagerConstruct;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.logging.Level;
import org.jetbrains.annotations.Nullable;

public class RulesManager {
    private List<String> lines;
    @InjectPlugin
    private EssentialZ plugin;

    @PostManagerConstruct
    public void init() {
        this.lines = this.readLines();
    }

    private File getRulesFile() {
        return new File(this.plugin.getDataFolder(), "rules.txt");
    }

    @Nullable
    private List<String> readLines() {
        ArrayList<String> lines = new ArrayList<String>();
        try (Scanner scanner = new Scanner(this.getRulesFile());){
            while (scanner.hasNextLine()) {
                lines.add(scanner.nextLine());
            }
        }
        catch (FileNotFoundException e) {
            this.plugin.getLogger().log(Level.SEVERE, "Failed to load rules file: " + e.getMessage(), e);
            return null;
        }
        return lines;
    }

    @Nullable
    public List<String> getLines() {
        if (this.lines == null) {
            this.lines = this.readLines();
        }
        if (this.lines == null) {
            return null;
        }
        return this.lines;
    }

    public boolean fileExists() {
        return this.getRulesFile().exists();
    }

    public boolean reload() {
        this.lines = this.readLines();
        return this.lines != null;
    }
}

