/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.movement;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.LanguageManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandPermissionException;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"gamemode"}, description="Change your or another player's gamemode.", usage="/gamemode <mode> [player]", permission="essentialz.gamemode", aliases={"gm"})
public class GamemodeCommand
extends EszCommand {
    @InjectManager
    private LanguageManager languageManager;

    public GamemodeCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandPermissionException, CommandUsageException {
        Player player;
        String rawGamemode = args.getArg(0);
        GameMode gamemode = this.parseGamemode(rawGamemode);
        if (gamemode == null) {
            throw new CommandUsageException("/gamemode <survival|creative|adventure|spectator> [player]");
        }
        Player targetPlayer = args.getPlayer(1, (JavaPlugin)this.getPlugin());
        if (!(targetPlayer == null || sender instanceof Player && (player = (Player)sender).getUniqueId().equals(targetPlayer.getUniqueId()))) {
            if (!Permission.GAMEMODE_OTHERS.has((Permissible)sender)) {
                throw new CommandPermissionException(Permission.GAMEMODE_OTHERS.getNode());
            }
            targetPlayer.setGameMode(gamemode);
            this.sendConfirmationMessage(targetPlayer, this.translateGamemode(gamemode));
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.MOVEMENT, "gamemodeSetOther", "&7Set {ac}{player}&7's gamemode to {ac}{gamemode}&7.", new MessageManager.Replaceable<String>("{player}", targetPlayer.getName()), new MessageManager.Replaceable<String>("{gamemode}", gamemode.name().toLowerCase())));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "specifyPlayerOrBePlayer", "{ac}You must specify a player or be a player to use this command.", new MessageManager.Replaceable[0]));
            return false;
        }
        player = (Player)sender;
        player.setGameMode(gamemode);
        this.sendConfirmationMessage(player, this.translateGamemode(gamemode));
        return true;
    }

    private GameMode parseGamemode(String gamemode) {
        if (gamemode == null) {
            return null;
        }
        return switch (gamemode) {
            case "survival", "0", "s" -> GameMode.SURVIVAL;
            case "creative", "1", "c" -> GameMode.CREATIVE;
            case "adventure", "2", "a" -> GameMode.ADVENTURE;
            case "spectator", "3", "sp" -> GameMode.SPECTATOR;
            default -> null;
        };
    }

    private String translateGamemode(GameMode gameMode) {
        return switch (gameMode) {
            default -> throw new MatchException(null, null);
            case GameMode.SURVIVAL -> this.languageManager.getString("survival", "survival");
            case GameMode.CREATIVE -> this.languageManager.getString("creative", "creative");
            case GameMode.ADVENTURE -> this.languageManager.getString("adventure", "adventure");
            case GameMode.SPECTATOR -> this.languageManager.getString("spectator", "spectator");
        };
    }

    private void sendConfirmationMessage(Player player, String gameMode) {
        player.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.MOVEMENT, "gamemodeSet", "&7Set your gamemode to {ac}{gamemode}&7.", new MessageManager.Replaceable<String>("{gamemode}", gameMode)));
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return this.getDisplayOptions(List.of("survival", "creative", "adventure", "spectator"), args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 1 && Permission.GAMEMODE_OTHERS.has((Permissible)sender)) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

