/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.moderation;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.CommandPlayerNotFoundException;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.List;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"sudo"}, description="Force a player to run a command.", usage="/sudo <player> <command>", permission="essentialz.sudo")
public class SudoCommand
extends EszCommand {
    public SudoCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandException {
        Player player = args.getPlayer(0, (JavaPlugin)this.getPlugin());
        String cmd = args.getJoinedString(1);
        if (args.getArg(0) == null) {
            throw new CommandUsageException("/sudo <player> <commandToExecute>");
        }
        if (player == null) {
            throw new CommandPlayerNotFoundException();
        }
        if (cmd.isEmpty()) {
            throw new CommandUsageException("/sudo <player> <commandToExecute>");
        }
        player.performCommand(cmd);
        sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.MODERATION, "sudoSuccess", "&7Successfully forced {ac}{player} &7to run the command: {ac}{command}&7.", new MessageManager.Replaceable<String>("{player}", player.getName()), new MessageManager.Replaceable<String>("{command}", cmd)));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 1) {
            return this.getCommandOptions(args.getCurrentArg());
        }
        return List.of();
    }

    private List<String> getCommandOptions(String currentArg) {
        return ((EssentialZ)((Object)this.getPlugin())).getServer().getCommandMap().getKnownCommands().values().stream().map(Command::getName).filter(cmdName -> cmdName.toLowerCase().startsWith(currentArg.toLowerCase())).toList();
    }
}

