/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.items;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.GiveMaterialManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandSenderMustBePlayerException;
import com.zetaplugins.zetacore.commands.exceptions.CommandUsageException;
import java.util.List;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

@AutoRegisterCommand(commands={"i"}, description="Gives yourself an item.", usage="/i <item> [amount]", permission="essentialz.give")
public class ICommand
extends EszCommand {
    @InjectManager
    private GiveMaterialManager giveMaterialManager;

    public ICommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandSenderMustBePlayerException, CommandUsageException {
        if (!(sender instanceof Player)) {
            throw new CommandSenderMustBePlayerException();
        }
        Player player = (Player)sender;
        String materialName = args.getArg(0);
        if (materialName == null) {
            throw new CommandUsageException("/give [player] <item> [amount]");
        }
        Material material = this.giveMaterialManager.getMaterialByKey(materialName);
        if (material == null) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "invalidMaterial", "{ac}'{material}' is not a valid material.", new MessageManager.Replaceable<String>("{material}", materialName)));
            return false;
        }
        int amount = args.getInt(1, 1);
        ItemStack itemStack = new ItemStack(material, amount);
        player.getInventory().addItem(new ItemStack[]{itemStack});
        sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ITEMS, "giveYourselfConfirmation", "&7You have been given {ac}{amount}x {material}&7.", new MessageManager.Replaceable<String>("{amount}", String.valueOf(amount)), new MessageManager.Replaceable<String>("{material}", material.name())));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0) {
            return this.getDisplayOptions(this.giveMaterialManager.getPossibleMaterials(), args.getCurrentArg());
        }
        if (args.getCurrentArgIndex() == 1) {
            return this.getDisplayOptions(List.of("1", "16", "32", "64"), args.getCurrentArg());
        }
        return List.of();
    }
}

