/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.economy;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.economy.manager.EconomyManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandException;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@AutoRegisterCommand(commands={"baltop"}, description="Show the top balances on the server", usage="/baltop", permission="essentialz.baltop")
public class BalTopCommand
extends EszCommand {
    @InjectManager
    private EconomyManager economyManager;
    @InjectManager
    private MessageManager messageManager;

    public BalTopCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String s, ArgumentList args) throws CommandException {
        Map<UUID, Double> topBalances = this.economyManager.getTopBalances(10);
        sender.sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ECONOMY, "balTopHeader", "\n&8\u250c\u2500 {ac}Top Balances&r&8 \u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500", false, new MessageManager.Replaceable[0]));
        int i = 1;
        for (UUID uuuid : topBalances.keySet()) {
            Player player = ((EssentialZ)((Object)this.getPlugin())).getServer().getPlayer(uuuid);
            OfflinePlayer offlinePlayer = ((EssentialZ)((Object)this.getPlugin())).getServer().getOfflinePlayer(uuuid);
            String playerName = player != null ? player.getName() : offlinePlayer.getName();
            double balance = topBalances.get(uuuid);
            sender.sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ECONOMY, "balTopEntry", "&8\u2502 {ac}{rank}. &7{player} &8- {ac}{balance}", false, new MessageManager.Replaceable<String>("{rank}", String.valueOf(i++)), new MessageManager.Replaceable<String>("{player}", playerName), new MessageManager.Replaceable<String>("{balance}", this.economyManager.format(balance))));
        }
        sender.sendMessage(this.messageManager.getAndFormatMsg(MessageManager.Style.ECONOMY, "balTopFooter", "&8\u2514\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\u2500\n", false, new MessageManager.Replaceable[0]));
        return true;
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        return List.of();
    }
}

