/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.commands.ArgumentList;
import java.util.List;
import org.bukkit.Statistic;
import org.bukkit.command.Command;
import org.bukkit.command.CommandException;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;

@AutoRegisterCommand(commands={"playtime"}, description="Get the playtime of a player", permission="essentialz.playtime", usage="/playtime [player]")
public class PlayTimeCommand
extends EszCommand {
    public PlayTimeCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandException {
        if (args.hasArg(0)) {
            Player target = ((EssentialZ)((Object)this.getPlugin())).getServer().getPlayer(args.getArg(0));
            if (target == null) {
                sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "playerNotFound", "&cPlayer not found.", new MessageManager.Replaceable[0]));
                return false;
            }
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.DEFAULT, "playTime", "&7{player} has played for {ac}{time}&7.", new MessageManager.Replaceable<String>("{player}", target.getName()), new MessageManager.Replaceable<String>("{time}", this.getPlayTime(target))));
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "specifyPlayerOrBePlayer", "&cYou must specify a player or be a player to use this command.", new MessageManager.Replaceable[0]));
            return false;
        }
        Player player = (Player)sender;
        sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.DEFAULT, "playTimeSelf", "&7You have played for {ac}{time}&7.", new MessageManager.Replaceable<String>("{time}", this.getPlayTime(player))));
        return true;
    }

    private String getPlayTime(Player player) {
        int playTime = player.getStatistic(Statistic.PLAY_ONE_MINUTE);
        int seconds = playTime / 20;
        int hours = seconds / 3600;
        int minutes = seconds % 3600 / 60;
        return String.format("%dh %dm", hours, minutes);
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0 || args.getCurrentArgIndex() == 1) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

