/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.zetacore.services.di;

import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.annotations.InjectPlugin;
import com.zetaplugins.zetacore.annotations.PostManagerConstruct;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import org.bukkit.plugin.java.JavaPlugin;

public class ManagerRegistry {
    private final JavaPlugin plugin;
    private final Map<Class<?>, Object> instances = new HashMap();

    public ManagerRegistry(JavaPlugin plugin) {
        this.plugin = plugin;
        this.instances.put(plugin.getClass(), plugin);
        this.instances.put(JavaPlugin.class, plugin);
    }

    public void registerInstance(Object instance) {
        this.injectManagers(instance);
        this.instances.put(instance.getClass(), instance);
    }

    public void registerInstance(Class<?> cls, Object instance) {
        this.injectManagers(instance);
        this.instances.put(cls, instance);
    }

    public <T> T getOrCreate(Class<T> cls) {
        Object existing = this.instances.get(cls);
        if (existing != null) {
            return (T)existing;
        }
        try {
            for (Constructor<?> constructor : cls.getDeclaredConstructors()) {
                Class<?>[] params = constructor.getParameterTypes();
                if (params.length == 1 && params[0].isAssignableFrom(this.plugin.getClass())) {
                    constructor.setAccessible(true);
                    Object obj = constructor.newInstance(this.plugin);
                    this.instances.put(cls, obj);
                    this.injectManagers(obj);
                    return (T)obj;
                }
                if (params.length != 1 || !params[0].isAssignableFrom(JavaPlugin.class)) continue;
                constructor.setAccessible(true);
                Object obj = constructor.newInstance(this.plugin);
                this.instances.put(cls, obj);
                this.injectManagers(obj);
                return (T)obj;
            }
            Constructor<T> noArg = cls.getDeclaredConstructor(new Class[0]);
            noArg.setAccessible(true);
            T obj = noArg.newInstance(new Object[0]);
            this.instances.put(cls, obj);
            this.injectManagers(obj);
            return obj;
        }
        catch (Exception e) {
            throw new RuntimeException("Failed to create instance of " + cls.getName(), e);
        }
    }

    public void injectManagers(Object target) {
        for (Class<?> cls = target.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
            for (Field field : cls.getDeclaredFields()) {
                this.injectManagerIntoField(field, target);
                this.injectPluginIntoField(field, target);
            }
        }
        this.callPostConstructMethods(target);
    }

    private void injectManagerIntoField(Field field, Object target) {
        if (field.isAnnotationPresent(InjectManager.class)) {
            Object instance = this.getOrCreate(field.getType());
            try {
                field.setAccessible(true);
                field.set(target, instance);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void injectPluginIntoField(Field field, Object target) {
        if (field.isAnnotationPresent(InjectPlugin.class)) {
            if (!JavaPlugin.class.isAssignableFrom(field.getType())) {
                throw new RuntimeException("Field " + field.getName() + " is annotated with @InjectPlugin but is not of type JavaPlugin or a subclass.");
            }
            try {
                field.setAccessible(true);
                field.set(target, this.plugin);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private void callPostConstructMethods(Object target) {
        for (Class<?> cls = target.getClass(); cls != null && cls != Object.class; cls = cls.getSuperclass()) {
            for (Method method : cls.getDeclaredMethods()) {
                if (!method.isAnnotationPresent(PostManagerConstruct.class)) continue;
                if (method.getParameterCount() != 0) {
                    throw new RuntimeException("@PostManagerConstruct method " + method.getName() + " must have no parameters");
                }
                try {
                    method.setAccessible(true);
                    method.invoke(target, new Object[0]);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to execute @PostManagerConstruct method " + method.getName(), e);
                }
            }
        }
    }
}

