/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.features.economy.manager;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.features.economy.EconomyConfig;
import com.zetaplugins.essentialz.features.economy.EconomyUtil;
import com.zetaplugins.essentialz.features.economy.manager.EconomyManager;
import com.zetaplugins.essentialz.storage.Storage;
import com.zetaplugins.essentialz.storage.model.PlayerData;
import com.zetaplugins.essentialz.util.EszConfig;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.annotations.PostManagerConstruct;
import com.zetaplugins.zetacore.services.config.ConfigService;
import java.util.Map;
import java.util.UUID;
import org.bukkit.OfflinePlayer;

public class BuiltinEconomyManager
implements EconomyManager {
    private EconomyConfig currencyConfig;
    @InjectManager
    private ConfigService configService;
    @InjectManager
    private Storage storage;
    @InjectManager
    private EssentialZ plugin;

    @PostManagerConstruct
    public void init() {
        this.currencyConfig = new EconomyConfig(this.configService.getConfig(EszConfig.ECONOMY));
    }

    @Override
    public double getBalance(OfflinePlayer player) {
        return this.storage.load(player.getUniqueId()).getBalance();
    }

    @Override
    public void deposit(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            amount = 0.0;
        }
        PlayerData playerData = this.storage.load(player.getUniqueId());
        double currentBalance = playerData.getBalance();
        playerData.setBalance(currentBalance + amount);
        this.storage.save(playerData);
    }

    @Override
    public boolean withdraw(OfflinePlayer player, double amount) {
        PlayerData playerData;
        double currentBalance;
        if (amount < 0.0) {
            amount = 0.0;
        }
        if ((currentBalance = (playerData = this.storage.load(player.getUniqueId())).getBalance()) < amount) {
            return false;
        }
        playerData.setBalance(currentBalance - amount);
        this.storage.save(playerData);
        return true;
    }

    @Override
    public void setBalance(OfflinePlayer player, double amount) {
        if (amount < 0.0) {
            amount = 0.0;
        }
        PlayerData playerData = this.storage.load(player.getUniqueId());
        playerData.setBalance(amount);
        this.storage.save(playerData);
    }

    @Override
    public String format(double amount) {
        return EconomyUtil.formatCurrency(amount, this.currencyConfig);
    }

    @Override
    public Map<UUID, Double> getTopBalances(int topN) {
        return this.storage.getTopBalances(topN);
    }
}

