/*
 * Decompiled with CFR 0.152.
 */
package com.zetaplugins.essentialz.commands.movement;

import com.zetaplugins.essentialz.EssentialZ;
import com.zetaplugins.essentialz.util.LanguageManager;
import com.zetaplugins.essentialz.util.MessageManager;
import com.zetaplugins.essentialz.util.commands.EszCommand;
import com.zetaplugins.essentialz.util.permissions.Permission;
import com.zetaplugins.zetacore.annotations.AutoRegisterCommand;
import com.zetaplugins.zetacore.annotations.InjectManager;
import com.zetaplugins.zetacore.commands.ArgumentList;
import com.zetaplugins.zetacore.commands.exceptions.CommandPermissionException;
import java.util.List;
import org.bukkit.GameMode;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.java.JavaPlugin;

@AutoRegisterCommand(commands={"gmc", "gms", "gma", "gmsp"}, description="Shortcut commands to change gamemodes.", usage="/<command> [player]", permission="essentialz.gamemode")
public class GamemodeShortcutCommand
extends EszCommand {
    @InjectManager
    private LanguageManager languageManager;

    public GamemodeShortcutCommand(EssentialZ plugin) {
        super(plugin);
    }

    @Override
    public boolean execute(CommandSender sender, Command command, String label, ArgumentList args) throws CommandPermissionException {
        Player player;
        Player targetPlayer = args.getPlayer(0, (JavaPlugin)this.getPlugin());
        if (!(targetPlayer == null || sender instanceof Player && (player = (Player)sender).getUniqueId().equals(targetPlayer.getUniqueId()))) {
            if (!Permission.GAMEMODE_OTHERS.has((Permissible)sender)) {
                throw new CommandPermissionException(Permission.GAMEMODE_OTHERS.getNode());
            }
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.MOVEMENT, "gamemodeSetOther", "&7Set {ac}{player}&7's gamemode to {ac}{gamemode}&7.", new MessageManager.Replaceable<String>("{player}", targetPlayer.getName()), new MessageManager.Replaceable<String>("{gamemode}", this.commandNameToGamemode(command.getName()))));
            this.setGamemode(targetPlayer, command.getName());
            return true;
        }
        if (!(sender instanceof Player)) {
            sender.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.ERROR, "specifyPlayerOrBePlayer", "{ac}You must specify a player or be a player to use this command.", new MessageManager.Replaceable[0]));
            return false;
        }
        player = (Player)sender;
        return this.setGamemode(player, command.getName());
    }

    private String commandNameToGamemode(String commandName) {
        return switch (commandName) {
            case "gmc" -> this.languageManager.getString("creative", "creative");
            case "gms" -> this.languageManager.getString("survival", "survival");
            case "gma" -> this.languageManager.getString("adventure", "adventure");
            case "gmsp" -> this.languageManager.getString("spectator", "spectator");
            default -> null;
        };
    }

    private boolean setGamemode(Player player, String commandName) {
        String gameMode = this.commandNameToGamemode(commandName);
        switch (commandName) {
            case "gmc": {
                player.setGameMode(GameMode.CREATIVE);
                this.sendConfirmationMessage(player, gameMode);
                return true;
            }
            case "gms": {
                player.setGameMode(GameMode.SURVIVAL);
                this.sendConfirmationMessage(player, gameMode);
                return true;
            }
            case "gma": {
                player.setGameMode(GameMode.ADVENTURE);
                this.sendConfirmationMessage(player, gameMode);
                return true;
            }
            case "gmsp": {
                player.setGameMode(GameMode.SPECTATOR);
                this.sendConfirmationMessage(player, gameMode);
                return true;
            }
        }
        return false;
    }

    private void sendConfirmationMessage(Player player, String gameMode) {
        player.sendMessage(this.getMessageManager().getAndFormatMsg(MessageManager.Style.MOVEMENT, "gamemodeSet", "&7Set your gamemode to {ac}{gamemode}&7.", new MessageManager.Replaceable<String>("{gamemode}", gameMode)));
    }

    @Override
    public List<String> tabComplete(CommandSender sender, Command command, ArgumentList args) {
        if (args.getCurrentArgIndex() == 0 && Permission.GAMEMODE_OTHERS.has((Permissible)sender)) {
            return this.getPlayerOptions(args.getCurrentArg());
        }
        return List.of();
    }
}

